/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.processor.meta.CriteriaMirrors;

public class CriteriaRepositoryMirror
implements CriteriaMirrors.CriteriaRepository {
    public static final String QUALIFIED_NAME = "org.immutables.criteria.Criteria.Repository";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.processor.meta.CriteriaMirrors.CriteriaRepository";
    private final AnnotationMirror annotationMirror;
    private final TypeMirror[] facets;
    private final String[] facetsName;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Repository";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static Optional<CriteriaRepositoryMirror> find(Element element) {
        return CriteriaRepositoryMirror.find(element.getAnnotationMirrors());
    }

    public static Optional<CriteriaRepositoryMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return Optional.of((Object)new CriteriaRepositoryMirror(annotationMirror));
        }
        return Optional.absent();
    }

    public static ImmutableList<CriteriaRepositoryMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Preconditions.checkState((boolean)element.getQualifiedName().contentEquals(QUALIFIED_NAME), (Object)"Supplied mirrors should all be of this annotation type");
            builder.add((Object)new CriteriaRepositoryMirror(annotationMirror));
        }
        return builder.build();
    }

    public static CriteriaRepositoryMirror from(TypeElement element) {
        return new CriteriaRepositoryMirror(element);
    }

    public static Optional<CriteriaRepositoryMirror> from(AnnotationMirror mirror) {
        return CriteriaRepositoryMirror.find(Collections.singleton(mirror));
    }

    private CriteriaRepositoryMirror(TypeElement defaultAnnotationElement) {
        Preconditions.checkArgument((defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME) ? 1 : 0) != 0);
        this.annotationMirror = null;
        TypeMirror[] facets = null;
        String[] facetsName = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"facets".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Repository");
            }
            FacetsExtractor facetsExtractor$ = new FacetsExtractor();
            annotationValue$.accept(facetsExtractor$, null);
            facets = facetsExtractor$.get();
            facetsName = facetsExtractor$.name();
        }
        this.facets = (TypeMirror[])Preconditions.checkNotNull(facets, (Object)"default attribute 'facets'");
        this.facetsName = (String[])Preconditions.checkNotNull(facetsName, (Object)"default attribute 'facets'");
    }

    private CriteriaRepositoryMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        TypeMirror[] facets = null;
        String[] facetsName = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"facets".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'facets' attribute of @Repository");
            }
            FacetsExtractor facetsExtractor$ = new FacetsExtractor();
            annotationValue$.accept(facetsExtractor$, null);
            facets = facetsExtractor$.get();
            facetsName = facetsExtractor$.name();
        }
        this.facets = (TypeMirror[])Preconditions.checkNotNull(facets, (Object)"value for 'facets'");
        this.facetsName = (String[])Preconditions.checkNotNull(facetsName, (Object)"Value for 'facets'");
    }

    public String[] facetsName() {
        return (String[])this.facetsName.clone();
    }

    public TypeMirror[] facetsMirror() {
        return (TypeMirror[])this.facets.clone();
    }

    @Override
    @Deprecated
    public Class<?>[] facets() {
        throw new UnsupportedOperationException("Use 'facetsMirror()' or 'facetsName()'");
    }

    public AnnotationMirror getAnnotationMirror() {
        Preconditions.checkState((this.annotationMirror != null ? 1 : 0) != 0, (Object)"this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return CriteriaMirrors.CriteriaRepository.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        return h += 127 * "facets".hashCode() ^ Arrays.hashCode(this.facetsName);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof CriteriaRepositoryMirror) {
            CriteriaRepositoryMirror otherMirror = (CriteriaRepositoryMirror)other;
            return Arrays.equals(this.facetsName, otherMirror.facetsName);
        }
        return false;
    }

    @Override
    public String toString() {
        return "CriteriaRepositoryMirror:" + this.annotationMirror;
    }

    private static class FacetsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        TypeMirror[] values;
        int position;

        private FacetsExtractor() {
        }

        @Override
        public Void visitType(TypeMirror value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new TypeMirror[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        TypeMirror[] get() {
            return this.values;
        }

        public String[] name() {
            String[] names = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                names[i] = this.values[i].toString();
            }
            return names;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'facets' in @org.immutables.criteria.Criteria.Repository");
        }
    }
}

