/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.metainf.internal.$generator$;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.immutables.metainf.internal.$generator$.$SourceTypes;
import org.immutables.metainf.retrofit.$guava$.base.$Verify;
import org.immutables.metainf.retrofit.$guava$.collect.$ImmutableList;
import org.immutables.metainf.retrofit.$guava$.collect.$ImmutableSet;
import org.immutables.metainf.retrofit.$guava$.collect.$Lists;
import org.immutables.metainf.retrofit.$guava$.collect.$Sets;

@NotThreadSafe
public class $TypeHierarchyCollector {
    private final List<TypeElement> extendedClasses = $Lists.newArrayList();
    private final Set<TypeElement> implementedInterfaces = $Sets.newLinkedHashSet();
    private final List<String> extendedClassNames = $Lists.newArrayList();
    private final Set<String> implementedInterfaceNames = $Sets.newLinkedHashSet();

    protected String stringify(DeclaredType input, TypevarContext context) {
        return $TypeHierarchyCollector.toTypeElement(input).getQualifiedName().toString();
    }

    public void collectFrom(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            this.collectHierarchyMirrors(typeMirror, typeMirror.toString());
        }
    }

    private DeclaredType toDeclaredType(TypeMirror typeMirror) {
        $Verify.verify(typeMirror.getKind() == TypeKind.DECLARED || typeMirror.getKind() == TypeKind.ERROR);
        return (DeclaredType)typeMirror;
    }

    public $ImmutableList<TypeElement> extendedClasses() {
        return $ImmutableList.copyOf(this.extendedClasses);
    }

    public $ImmutableSet<TypeElement> implementedInterfaces() {
        return $ImmutableSet.copyOf(this.implementedInterfaces);
    }

    public $ImmutableList<String> extendedClassNames() {
        return $ImmutableList.copyOf(this.extendedClassNames);
    }

    public $ImmutableSet<String> implementedInterfaceNames() {
        return $ImmutableSet.copyOf(this.implementedInterfaceNames);
    }

    private void collectHierarchyMirrors(TypeMirror typeMirror, String stringRepresentation) {
        DeclaredType superclass;
        String string;
        if (typeMirror.getKind() != TypeKind.DECLARED || typeMirror.toString().equals(Object.class.getName())) {
            return;
        }
        DeclaredType declaredType = this.toDeclaredType(typeMirror);
        TypeElement e = $TypeHierarchyCollector.toTypeElement(declaredType);
        TypevarContext context = new TypevarContext(e, stringRepresentation);
        this.collectInterfacesMirrors(declaredType, context);
        TypeMirror superclassMirror = e.getSuperclass();
        if (superclassMirror.getKind() != TypeKind.NONE && !(string = this.stringify(superclass = this.toDeclaredType(superclassMirror), context)).equals(Object.class.getName())) {
            this.extendedClasses.add($TypeHierarchyCollector.toTypeElement(superclass));
            this.extendedClassNames.add(string);
            this.collectHierarchyMirrors(superclass, string);
        }
        for (TypeMirror typeMirror2 : e.getInterfaces()) {
            this.collectUnresolvedInterface(typeMirror2, context);
            this.collectInterfacesMirrors(typeMirror2, context);
        }
    }

    private void collectUnresolvedInterface(TypeMirror typeMirror, TypevarContext context) {
        if (typeMirror.getKind() == TypeKind.ERROR) {
            DeclaredType declaredType = this.toDeclaredType(typeMirror);
            String stringified = this.stringify(declaredType, context);
            this.implementedInterfaceNames.add(stringified);
        }
    }

    private void collectInterfacesMirrors(TypeMirror typeMirror, TypevarContext context) {
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return;
        }
        DeclaredType declaredType = this.toDeclaredType(typeMirror);
        TypeElement e = $TypeHierarchyCollector.toTypeElement(declaredType);
        if (e.getKind().isInterface()) {
            this.implementedInterfaces.add(e);
            String stringified = this.stringify(declaredType, context);
            TypevarContext nestedContext = new TypevarContext(e, stringified);
            this.implementedInterfaceNames.add(stringified);
            for (TypeMirror typeMirror2 : e.getInterfaces()) {
                this.collectInterfacesMirrors(typeMirror2, nestedContext);
            }
        }
    }

    private static TypeElement toTypeElement(DeclaredType input) {
        return (TypeElement)input.asElement();
    }

    public final class TypevarContext {
        public final List<String> parameters;
        public final List<String> arguments;

        TypevarContext(TypeElement element, String renderedTypeString) {
            List<? extends TypeParameterElement> typeParameters = element.getTypeParameters();
            if (!typeParameters.isEmpty()) {
                this.arguments = $SourceTypes.extract(renderedTypeString).getValue();
                this.parameters = $Lists.newArrayList();
                for (TypeParameterElement typeParameterElement : typeParameters) {
                    this.parameters.add(typeParameterElement.getSimpleName().toString());
                }
                $Verify.verify(this.arguments.isEmpty() || this.parameters.size() == this.arguments.size(), this.parameters + " =/> " + this.arguments, new Object[0]);
            } else {
                this.parameters = Collections.emptyList();
                this.arguments = Collections.emptyList();
            }
        }
    }
}

