/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Objects;

public abstract class Naming
implements Function<String, String> {
    private static final String NOT_DETECTED = "";
    private static final String NAME_PLACEHOLDER = "*";
    private static final Splitter TEMPLATE_SPLITTER = Splitter.on((String)"*");
    private static final CharMatcher TEMPLATE_CHAR_MATCHER = CharMatcher.is((char)'_').or(CharMatcher.is((char)"*".charAt(0))).or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).precomputed();
    private static final Naming IDENTITY_NAMING = new Naming(){

        @Override
        public String apply(String input) {
            return input;
        }

        @Override
        public String detect(String identifier) {
            return identifier;
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public Naming requireNonConstant(Preference preference) {
            return this;
        }

        @Override
        public Naming requireJavaBeanConvention() {
            return this;
        }

        public String toString() {
            return Naming.NAME_PLACEHOLDER;
        }
    };

    private Naming() {
    }

    public abstract String apply(String var1);

    public abstract String detect(String var1);

    public abstract boolean isIdentity();

    public abstract boolean isConstant();

    public abstract Naming requireNonConstant(Preference var1);

    public abstract Naming requireJavaBeanConvention();

    public static Naming identity() {
        return IDENTITY_NAMING;
    }

    public static Naming from(String template) {
        if (template.isEmpty() || template.equals(NAME_PLACEHOLDER)) {
            return IDENTITY_NAMING;
        }
        Preconditions.checkArgument((boolean)TEMPLATE_CHAR_MATCHER.matchesAllOf((CharSequence)template), (String)"Naming template [%s] contains unsupported characters, only java identifier chars and '*' placeholder are allowed (ASCII only)", (Object)template);
        List parts = TEMPLATE_SPLITTER.splitToList((CharSequence)template);
        Preconditions.checkArgument((parts.size() <= 2 ? 1 : 0) != 0, (String)"Naming template [%s] contains more than one '*' placeholder, which is unsupported", (Object)template);
        return parts.size() == 1 ? new ConstantNaming(template) : new PrefixSuffixNaming((String)parts.get(0), (String)parts.get(1));
    }

    public static Naming[] fromAll(String ... templates) {
        Naming[] namings = new Naming[templates.length];
        for (int i = 0; i < templates.length; ++i) {
            namings[i] = Naming.from(templates[i]);
        }
        return namings;
    }

    private static class ConstantNaming
    extends Naming {
        final String name;

        ConstantNaming(String name) {
            this.name = name;
        }

        @Override
        public String apply(String input) {
            return this.name;
        }

        @Override
        public String detect(String identifier) {
            return identifier.equals(this.name) ? this.name : Naming.NOT_DETECTED;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        @Override
        public Naming requireNonConstant(Preference preference) {
            switch (preference.ordinal()) {
                case 1: {
                    return new PrefixSuffixNaming(Naming.NOT_DETECTED, Usage.CAPITALIZED.apply(this.name));
                }
            }
            return new PrefixSuffixNaming(this.name, Naming.NOT_DETECTED);
        }

        @Override
        public Naming requireJavaBeanConvention() {
            return new JavaBeanNaming(this.name);
        }

        public String toString() {
            return this.name;
        }
    }

    private static class PrefixSuffixNaming
    extends Naming {
        final String prefix;
        final String suffix;
        final int lengthsOfPrefixAndSuffix;

        PrefixSuffixNaming(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.lengthsOfPrefixAndSuffix = suffix.length() + prefix.length();
            Preconditions.checkArgument((this.lengthsOfPrefixAndSuffix > 0 ? 1 : 0) != 0);
        }

        @Override
        public String apply(String input) {
            Usage resultFormat = this.prefix.isEmpty() ? Usage.INDIFFERENT : Usage.CAPITALIZED;
            return this.prefix + resultFormat.apply(input) + this.suffix;
        }

        @Override
        public String detect(String identifier) {
            boolean suffixMatches;
            if (identifier.length() <= this.lengthsOfPrefixAndSuffix) {
                return Naming.NOT_DETECTED;
            }
            boolean prefixMatches = this.prefix.isEmpty() || identifier.startsWith(this.prefix) && Ascii.isUpperCase((char)identifier.charAt(this.prefix.length()));
            boolean bl = suffixMatches = this.suffix.isEmpty() || identifier.endsWith(this.suffix);
            if (prefixMatches && suffixMatches) {
                String detected = identifier.substring(this.prefix.length(), identifier.length() - this.suffix.length());
                return this.prefix.isEmpty() ? detected : CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, detected);
            }
            return Naming.NOT_DETECTED;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public Naming requireNonConstant(Preference preference) {
            return this;
        }

        @Override
        public Naming requireJavaBeanConvention() {
            return new JavaBeanNaming(this.prefix);
        }

        public String toString() {
            return this.prefix + Naming.NAME_PLACEHOLDER + this.suffix;
        }
    }

    private static class JavaBeanNaming
    extends Naming {
        private final String prefix;

        JavaBeanNaming(String prefix) {
            this.prefix = Objects.requireNonNull(prefix, "prefix");
        }

        @Override
        public String apply(String input) {
            return this.prefix + Usage.CAPITALIZED.apply(input);
        }

        @Override
        public String detect(String identifier) {
            if (!identifier.startsWith(this.prefix)) {
                return Naming.NOT_DETECTED;
            }
            String name = identifier.substring(this.prefix.length());
            if (name.length() > 1 && Character.isUpperCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
                return name;
            }
            return Usage.LOWERIZED.apply(name);
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public Naming requireNonConstant(Preference preference) {
            if (preference != Preference.PREFIX) {
                throw new IllegalArgumentException(String.format("Preference %s not supported by %s", new Object[]{preference, this.getClass().getSimpleName()}));
            }
            return this;
        }

        @Override
        public Naming requireJavaBeanConvention() {
            return this;
        }
    }

    public static enum Usage {
        INDIFFERENT,
        CAPITALIZED,
        LOWERIZED;


        public String apply(String input) {
            if (!input.isEmpty()) {
                if (this == CAPITALIZED && !Ascii.isUpperCase((char)input.charAt(0))) {
                    return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, input);
                }
                if (this == LOWERIZED && !Ascii.isLowerCase((char)input.charAt(0))) {
                    return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, input);
                }
            }
            return input;
        }
    }

    public static enum Preference {
        PREFIX,
        SUFFIX;

    }
}

