/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.generator;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MutableClassToInstanceMap;
import java.lang.ref.WeakReference;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;

public class EnvironmentState {
    private static final ThreadLocal<WeakReference<EnvironmentState>> currentState = new ThreadLocal();
    private ProcessingEnvironment processing;
    private RoundEnvironment round;
    private Set<TypeElement> annotations;
    private final ClassToInstanceMap<Runnable> afterProcessing = MutableClassToInstanceMap.create();
    private final ClassToInstanceMap<Runnable> afterRound = MutableClassToInstanceMap.create();

    private static EnvironmentState state() {
        WeakReference reference = (WeakReference)Preconditions.checkNotNull(currentState.get(), (Object)"Static environment should be initialized");
        return (EnvironmentState)Preconditions.checkNotNull((Object)((EnvironmentState)reference.get()), (Object)"State should still be strongly referenced elsewhere");
    }

    public static <T extends Runnable> T getPerRound(Class<T> type, Supplier<T> supplier) {
        EnvironmentState state = EnvironmentState.state();
        Runnable instance = (Runnable)state.afterRound.getInstance(type);
        if (instance == null) {
            instance = (Runnable)supplier.get();
            state.afterRound.putInstance(type, (Object)instance);
        }
        return (T)instance;
    }

    public static <T extends Runnable> T getPerProcessing(Class<T> type, Supplier<T> supplier) {
        EnvironmentState state = EnvironmentState.state();
        Runnable instance = (Runnable)state.afterProcessing.getInstance(type);
        if (instance == null) {
            instance = (Runnable)supplier.get();
            state.afterProcessing.putInstance(type, (Object)instance);
        }
        return (T)instance;
    }

    public static ProcessingEnvironment processing() {
        return EnvironmentState.state().processing;
    }

    public static RoundEnvironment round() {
        return EnvironmentState.state().round;
    }

    static Set<TypeElement> annotations() {
        return EnvironmentState.state().annotations;
    }

    void initProcessing(ProcessingEnvironment processing) {
        this.processing = processing;
        currentState.set(new WeakReference<EnvironmentState>(this));
    }

    void initRound(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        this.round = round;
        this.annotations = ImmutableSet.copyOf(annotations);
        currentState.set(new WeakReference<EnvironmentState>(this));
    }

    void completeRound() {
        for (Runnable r : this.afterRound.values()) {
            r.run();
        }
        this.afterRound.clear();
        this.annotations = null;
    }

    void completeProcessing() {
        for (Runnable r : this.afterProcessing.values()) {
            r.run();
        }
        this.afterProcessing.clear();
        currentState.remove();
    }
}

