/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileNIO;

public final class ScaledRAFileHybrid
implements RandomAccessInterface {
    final Database database;
    final String fileName;
    final boolean isReadOnly;
    boolean wasNio;
    long maxLength = Long.MAX_VALUE;
    RandomAccessInterface store;

    public ScaledRAFileHybrid(Database database, String string, boolean bl) throws IOException {
        this.database = database;
        this.fileName = string;
        this.isReadOnly = bl;
        File file = new File(string);
        long l = file.length();
        this.newStore(l);
    }

    public long length() throws IOException {
        return this.store.length();
    }

    public void seek(long l) throws IOException {
        this.store.seek(l);
    }

    public long getFilePointer() throws IOException {
        return this.store.getFilePointer();
    }

    public int read() throws IOException {
        return this.store.read();
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        this.store.read(byArray, n, n2);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.store.write(byArray, n, n2);
    }

    public int readInt() throws IOException {
        return this.store.readInt();
    }

    public void writeInt(int n) throws IOException {
        this.store.writeInt(n);
    }

    public long readLong() throws IOException {
        return this.store.readLong();
    }

    public void writeLong(long l) throws IOException {
        this.store.writeLong(l);
    }

    public void close() throws IOException {
        this.store.close();
    }

    public boolean isReadOnly() {
        return this.store.isReadOnly();
    }

    public boolean wasNio() {
        return this.wasNio;
    }

    public boolean ensureLength(long l) {
        if (l < this.maxLength && this.store.ensureLength(l)) {
            return true;
        }
        if (this.wasNio && !this.store.wasNio()) {
            return false;
        }
        try {
            this.newStore(l);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.store.ensureLength(l);
    }

    public boolean setLength(long l) {
        return this.store.setLength(l);
    }

    public Database getDatabase() {
        return null;
    }

    public void synch() {
        this.store.synch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newStore(long l) throws IOException {
        long l2 = 0L;
        if (this.store != null) {
            l2 = this.store.getFilePointer();
            this.store.synch();
            this.store.close();
        }
        if (this.wasNio) {
            this.maxLength = Long.MAX_VALUE;
        } else if (l <= this.database.logger.propNioMaxSize) {
            if (l >= 0x800000L) {
                try {
                    try {
                        this.store = new ScaledRAFileNIO(this.database, this.fileName, this.isReadOnly, l, this.database.logger.propNioMaxSize);
                        this.store.seek(l2);
                        this.wasNio = true;
                        Object var7_3 = null;
                        this.maxLength = Long.MAX_VALUE;
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var7_4 = null;
                        this.maxLength = Long.MAX_VALUE;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    this.maxLength = Long.MAX_VALUE;
                    throw throwable;
                }
            } else {
                this.maxLength = 0x800000L;
            }
        }
        this.store = new ScaledRAFile(this.database, this.fileName, this.isReadOnly, true);
        this.store.seek(l2);
    }
}

