/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hsqldb.Database;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.RandomAccessInterface;
import org.hsqldb.persist.ScaledRAFileHybrid;
import org.hsqldb.persist.ScaledRAFileInJar;

final class ScaledRAFile
implements RandomAccessInterface {
    static final int DATA_FILE_RAF = 0;
    static final int DATA_FILE_NIO = 1;
    static final int DATA_FILE_JAR = 2;
    static final int DATA_FILE_STORED = 3;
    static final int DATA_FILE_SINGLE = 4;
    static final int DATA_FILE_TEXT = 5;
    static final int bufferScale = 12;
    static final int bufferSize = 4096;
    static final long bufferMask = -4096L;
    final Database database;
    final RandomAccessFile file;
    final FileDescriptor fileDescriptor;
    private final boolean readOnly;
    final String fileName;
    final byte[] buffer;
    final HsqlByteArrayInputStream ba;
    final byte[] valueBuffer;
    final HsqlByteArrayOutputStream vbao;
    final HsqlByteArrayInputStream vbai;
    long bufferOffset;
    long fileLength;
    final boolean extendLength;
    long seekPosition;
    int cacheHit;

    static RandomAccessInterface newScaledRAFile(Database database, String string, boolean bl, int n) throws FileNotFoundException, IOException {
        if (n == 3) {
            try {
                String string2 = database.getURLProperties().getProperty("storage_class_name");
                String string3 = database.getURLProperties().getProperty("storage_key");
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getConstructor(String.class, Boolean.class, Object.class);
                return (RandomAccessInterface)constructor.newInstance(string, new Boolean(bl), string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException();
            }
            catch (InstantiationException instantiationException) {
                throw new IOException();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IOException();
            }
        }
        if (n == 2) {
            return new ScaledRAFileInJar(string);
        }
        if (n == 5) {
            ScaledRAFile scaledRAFile = new ScaledRAFile(database, string, bl, false);
            return scaledRAFile;
        }
        if (n == 0) {
            return new ScaledRAFile(database, string, bl, true);
        }
        File file = new File(string);
        long l = file.length();
        if (l > database.logger.propNioMaxSize) {
            return new ScaledRAFile(database, string, bl, true);
        }
        try {
            Class.forName("java.nio.MappedByteBuffer");
            return new ScaledRAFileHybrid(database, string, bl);
        }
        catch (Exception exception) {
            return new ScaledRAFile(database, string, bl, true);
        }
    }

    ScaledRAFile(Database database, String string, boolean bl, boolean bl2) throws FileNotFoundException, IOException {
        this.database = database;
        this.fileName = string;
        this.readOnly = bl;
        this.extendLength = bl2;
        String string2 = bl ? "r" : (this.extendLength ? "rw" : "rws");
        this.file = new RandomAccessFile(string, string2);
        this.buffer = new byte[4096];
        this.ba = new HsqlByteArrayInputStream(this.buffer);
        this.valueBuffer = new byte[8];
        this.vbao = new HsqlByteArrayOutputStream(this.valueBuffer);
        this.vbai = new HsqlByteArrayInputStream(this.valueBuffer);
        this.fileDescriptor = this.file.getFD();
        this.fileLength = this.length();
        this.readIntoBuffer();
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public void seek(long l) throws IOException {
        if (this.readOnly && this.fileLength < l) {
            throw new IOException("read beyond end of file");
        }
        this.seekPosition = l;
    }

    public long getFilePointer() throws IOException {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        long l = this.seekPosition & 0xFFFFFFFFFFFFF000L;
        long l2 = this.fileLength - l;
        if (l2 > (long)this.buffer.length) {
            l2 = this.buffer.length;
        }
        if (l2 < 0L) {
            throw new IOException("read beyond end of file");
        }
        try {
            this.file.seek(l);
            this.file.readFully(this.buffer, 0, (int)l2);
            this.bufferOffset = l;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.database.logger.logWarningEvent(" " + l + " " + l2, iOException);
            throw iOException;
        }
    }

    public int read() throws IOException {
        try {
            if (this.seekPosition >= this.fileLength) {
                return -1;
            }
            if (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            int n = this.buffer[(int)(this.seekPosition - this.bufferOffset)] & 0xFF;
            ++this.seekPosition;
            return n;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.database.logger.logWarningEvent("read failed", iOException);
            throw iOException;
        }
    }

    public long readLong() throws IOException {
        this.vbai.reset();
        this.read(this.valueBuffer, 0, 8);
        return this.vbai.readLong();
    }

    public int readInt() throws IOException {
        this.vbai.reset();
        this.read(this.valueBuffer, 0, 4);
        return this.vbai.readInt();
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        try {
            if (this.seekPosition + (long)n2 > this.fileLength) {
                throw new EOFException();
            }
            if (n2 > this.buffer.length && (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length)) {
                this.file.seek(this.seekPosition);
                this.file.readFully(byArray, n, n2);
                this.seekPosition += (long)n2;
                return;
            }
            if (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            this.ba.reset();
            if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            int n3 = this.ba.read(byArray, n, n2);
            this.seekPosition += (long)n3;
            if (n3 < n2) {
                this.file.seek(this.seekPosition);
                this.file.readFully(byArray, n + n3, n2 - n3);
                this.seekPosition += (long)(n2 - n3);
            }
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.database.logger.logWarningEvent("faeild to read a byte array", iOException);
            throw iOException;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.file.seek(this.seekPosition);
            if (this.seekPosition < this.bufferOffset + (long)this.buffer.length && this.seekPosition + (long)n2 > this.bufferOffset) {
                this.writeToBuffer(byArray, n, n2);
            }
            this.file.write(byArray, n, n2);
            this.seekPosition += (long)n2;
            if (!this.extendLength && this.fileLength < this.seekPosition) {
                this.fileLength = this.seekPosition;
            }
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.database.logger.logWarningEvent("failed to write a byte array", iOException);
            throw iOException;
        }
    }

    public void writeInt(int n) throws IOException {
        this.vbao.reset();
        this.vbao.writeInt(n);
        this.write(this.valueBuffer, 0, 4);
    }

    public void writeLong(long l) throws IOException {
        this.vbao.reset();
        this.vbao.writeLong(l);
        this.write(this.valueBuffer, 0, 8);
    }

    public void close() throws IOException {
        this.file.close();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean wasNio() {
        return false;
    }

    public boolean ensureLength(long l) {
        if (l <= this.fileLength) {
            return true;
        }
        try {
            this.extendLength(l);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean setLength(long l) {
        try {
            this.file.setLength(l);
            this.file.seek(0L);
            this.fileLength = this.file.length();
            this.seekPosition = 0L;
            this.readIntoBuffer();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void synch() {
        try {
            this.fileDescriptor.sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeToBuffer(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n2;
        int n5 = n;
        int n6 = (int)(this.seekPosition - this.bufferOffset);
        if (n6 < 0) {
            n5 -= n6;
            n4 += n6;
            n6 = 0;
        }
        if ((n3 = (int)(this.bufferOffset + (long)this.buffer.length - this.seekPosition)) < n4) {
            n4 = n3;
        }
        System.arraycopy(byArray, n5, this.buffer, n6, n4);
    }

    private long getExtendLength(long l) {
        if (!this.extendLength) {
            return l;
        }
        int n = l < 262144L ? 2 : (l < 0x100000L ? 6 : (l < 0x1000000L ? 8 : 10));
        l = ScaledRAFile.getBinaryNormalisedCeiling(l, 12 + n);
        return l;
    }

    private void extendLength(long l) throws IOException {
        long l2 = this.getExtendLength(l);
        if (l2 > this.fileLength) {
            try {
                this.file.seek(l2 - 1L);
                this.file.write(0);
                this.fileLength = l2;
            }
            catch (IOException iOException) {
                this.database.logger.logWarningEvent("data file enlarge failed ", iOException);
                throw iOException;
            }
        }
    }

    private void resetPointer() {
        try {
            this.seekPosition = 0L;
            this.fileLength = this.length();
            this.readIntoBuffer();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static long getBinaryNormalisedCeiling(long l, int n) {
        long l2 = -1L << n;
        long l3 = l & l2;
        if (l3 != l) {
            l3 += (long)(1 << n);
        }
        return l3;
    }
}

