/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Random;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.java.JavaSystem;

public class FileUtil
implements FileAccess {
    private static FileUtil fileUtil = new FileUtil();
    private static FileAccessRes fileAccessRes = new FileAccessRes();
    public final boolean fsIsIgnoreCase = new File("A").equals(new File("a"));
    public final boolean fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);
    final Random random = new Random(System.currentTimeMillis());

    FileUtil() {
    }

    public static FileUtil getFileUtil() {
        return fileUtil;
    }

    public static FileAccess getFileAccess(boolean bl) {
        return bl ? fileAccessRes : fileUtil;
    }

    public boolean isStreamElement(String string) {
        return new File(string).exists();
    }

    public InputStream openInputStreamElement(String string) throws IOException {
        try {
            return new FileInputStream(new File(string));
        }
        catch (Throwable throwable) {
            throw JavaSystem.toIOException(throwable);
        }
    }

    public void createParentDirs(String string) {
        this.makeParentDirectories(new File(string));
    }

    public void removeElement(String string) {
        if (this.isStreamElement(string)) {
            this.delete(string);
        }
    }

    public void renameElement(String string, String string2) {
        this.renameWithOverwrite(string, string2);
    }

    public OutputStream openOutputStreamElement(String string) throws IOException {
        return new FileOutputStream(new File(string));
    }

    public boolean delete(String string) {
        return new File(string).delete();
    }

    public void deleteOnExit(File file) {
        JavaSystem.deleteOnExit(file);
    }

    public boolean exists(String string) {
        return new File(string).exists();
    }

    public boolean exists(String string, boolean bl, Class clazz) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return bl ? null != clazz.getResource(string) : FileUtil.getFileUtil().exists(string);
    }

    private boolean renameWithOverwrite(String string, String string2) {
        File file = new File(string);
        boolean bl = file.renameTo(new File(string2));
        if (bl) {
            return true;
        }
        if (this.delete(string2)) {
            return file.renameTo(new File(string2));
        }
        return false;
    }

    public String absolutePath(String string) {
        return new File(string).getAbsolutePath();
    }

    public File canonicalFile(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    public File canonicalFile(String string) throws IOException {
        return new File(new File(string).getCanonicalPath());
    }

    public String canonicalPath(File file) throws IOException {
        return file.getCanonicalPath();
    }

    public String canonicalPath(String string) throws IOException {
        return new File(string).getCanonicalPath();
    }

    public String canonicalOrAbsolutePath(String string) {
        try {
            return this.canonicalPath(string);
        }
        catch (Exception exception) {
            return this.absolutePath(string);
        }
    }

    public void makeParentDirectories(File file) {
        String string = file.getParent();
        if (string != null) {
            new File(string).mkdirs();
        } else {
            string = file.getPath();
            int n = string.lastIndexOf(47);
            if (n > 0) {
                string = string.substring(0, n);
                new File(string).mkdirs();
            }
        }
    }

    public static String makeDirectories(String string) {
        try {
            File file = new File(string);
            file.mkdirs();
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public FileAccess.FileSync getFileSync(OutputStream outputStream) throws IOException {
        return new FileSync((FileOutputStream)outputStream);
    }

    public static class FileAccessRes
    implements FileAccess {
        public boolean isStreamElement(String string) {
            URL uRL = null;
            try {
                ClassLoader classLoader;
                uRL = this.getClass().getResource(string);
                if (uRL == null && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
                    uRL = classLoader.getResource(string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return uRL != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public InputStream openInputStreamElement(String string) throws IOException {
            InputStream inputStream = null;
            try {
                try {
                    ClassLoader classLoader;
                    inputStream = this.getClass().getResourceAsStream(string);
                    if (inputStream == null && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
                        inputStream = classLoader.getResourceAsStream(string);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (inputStream != null) return inputStream;
                    throw new FileNotFoundException(string);
                }
                Object var5_5 = null;
                if (inputStream != null) return inputStream;
                throw new FileNotFoundException(string);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (inputStream != null) throw throwable;
                throw new FileNotFoundException(string);
            }
        }

        public void createParentDirs(String string) {
        }

        public void removeElement(String string) {
        }

        public void renameElement(String string, String string2) {
        }

        public OutputStream openOutputStreamElement(String string) throws IOException {
            throw new IOException();
        }

        public FileAccess.FileSync getFileSync(OutputStream outputStream) throws IOException {
            throw new IOException();
        }
    }

    public static class FileSync
    implements FileAccess.FileSync {
        FileDescriptor outDescriptor;

        FileSync(FileOutputStream fileOutputStream) throws IOException {
            this.outDescriptor = fileOutputStream.getFD();
        }

        public void sync() throws IOException {
            this.outDescriptor.sync();
        }
    }
}

