/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.io.Serializable;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.Xid;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCCommonDataSource;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCDriver;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.pool.JDBCXAConnection;
import org.hsqldb.jdbc.pool.JDBCXAResource;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;

public class JDBCXADataSource
extends JDBCCommonDataSource
implements XADataSource,
Serializable,
Referenceable {
    private HashMap resources = new HashMap();

    public XAConnection getXAConnection() throws SQLException {
        JDBCConnection jDBCConnection = (JDBCConnection)JDBCDriver.getConnection(this.url, this.connectionProps);
        JDBCXAConnection jDBCXAConnection = new JDBCXAConnection(this, jDBCConnection);
        return jDBCXAConnection;
    }

    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        if (string == null || string2 == null) {
            throw Util.nullArgument();
        }
        if (string.equals(this.user) && string2.equals(this.password)) {
            return this.getXAConnection();
        }
        throw Util.sqlException(Error.error(4000));
    }

    public Reference getReference() throws NamingException {
        String string = "org.hsqldb.jdbc.JDBCDataSourceFactory";
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("database", this.getDatabase()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.password));
        reference.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        return reference;
    }

    public void addResource(Xid xid, JDBCXAResource jDBCXAResource) {
        this.resources.put(xid, jDBCXAResource);
    }

    public JDBCXAResource removeResource(Xid xid) {
        return (JDBCXAResource)this.resources.remove(xid);
    }

    Xid[] getPreparedXids() {
        Iterator iterator = this.resources.keySet().iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            Xid xid = (Xid)iterator.next();
            if (((JDBCXAResource)this.resources.get((Object)xid)).state != JDBCXAResource.XA_STATE_PREPARED) continue;
            hashSet.add(xid);
        }
        return (Xid[])hashSet.toArray(new Xid[0]);
    }

    JDBCXAResource getResource(Xid xid) {
        return (JDBCXAResource)this.resources.get(xid);
    }
}

