/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.hsqldb.DatabaseURL;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.Util;
import org.hsqldb.persist.HsqlProperties;

public class JDBCDriver
implements Driver {
    public static JDBCDriver driverInstance;
    public final ThreadLocal threadConnection = new ThreadLocal();

    public Connection connect(String string, Properties properties) throws SQLException {
        if (string.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length())) {
            JDBCConnection jDBCConnection = (JDBCConnection)this.threadConnection.get();
            if (jDBCConnection == null) {
                return null;
            }
            return jDBCConnection;
        }
        return JDBCDriver.getConnection(string, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Connection getConnection(String string, Properties properties) throws SQLException {
        SQLException[] sQLExceptionArray;
        JDBCConnection[] jDBCConnectionArray;
        block20: {
            String string2;
            final HsqlProperties hsqlProperties = DatabaseURL.parseURL(string, true, false);
            if (hsqlProperties == null) {
                throw Util.invalidArgument();
            }
            if (hsqlProperties.isEmpty()) {
                return null;
            }
            long l = 0L;
            if (properties != null && properties.containsKey("loginTimeout") && (string2 = properties.getProperty("loginTimeout")) != null && (string2 = string2.trim()).length() > 0) {
                try {
                    l = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            hsqlProperties.addProperties(properties);
            if (l == 0L) {
                l = DriverManager.getLoginTimeout();
            }
            if (l == 0L) {
                return new JDBCConnection(hsqlProperties);
            }
            string2 = hsqlProperties.getProperty("connection_type");
            if (DatabaseURL.isInProcessDatabaseType(string2)) {
                return new JDBCConnection(hsqlProperties);
            }
            jDBCConnectionArray = new JDBCConnection[1];
            sQLExceptionArray = new SQLException[1];
            Thread thread = new Thread(){

                public void run() {
                    try {
                        jDBCConnectionArray[0] = new JDBCConnection(hsqlProperties);
                    }
                    catch (SQLException sQLException) {
                        sQLExceptionArray[0] = sQLException;
                    }
                }
            };
            thread.start();
            long l2 = System.currentTimeMillis();
            try {
                thread.join(1000L * l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            thread.stop();
            Object var13_12 = null;
            try {
                thread.setContextClassLoader(null);
            }
            catch (Throwable throwable) {}
            break block20;
            {
                catch (Exception exception) {
                    Object var13_13 = null;
                    try {
                        thread.setContextClassLoader(null);
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    thread.setContextClassLoader(null);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (sQLExceptionArray[0] != null) {
            throw sQLExceptionArray[0];
        }
        if (jDBCConnectionArray[0] != null) {
            return jDBCConnectionArray[0];
        }
        throw Util.sqlException(1351);
    }

    public boolean acceptsURL(String string) {
        if (string == null) {
            return false;
        }
        if (string.regionMatches(true, 0, "jdbc:hsqldb:", 0, "jdbc:hsqldb:".length())) {
            return true;
        }
        return string.regionMatches(true, 0, "jdbc:default:connection", 0, "jdbc:default:connection".length());
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        if (!this.acceptsURL(string)) {
            return new DriverPropertyInfo[0];
        }
        String[] stringArray = new String[]{"true", "false"};
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[6];
        if (properties == null) {
            properties = new Properties();
        }
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("user", null);
        driverPropertyInfo.value = properties.getProperty("user");
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[0] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("password", null);
        driverPropertyInfo.value = properties.getProperty("password");
        driverPropertyInfo.required = true;
        driverPropertyInfoArray[1] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("get_column_name", null);
        driverPropertyInfo.value = properties.getProperty("get_column_name", "true");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[2] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("ifexists", null);
        driverPropertyInfo.value = properties.getProperty("ifexists", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[3] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("default_schema", null);
        driverPropertyInfo.value = properties.getProperty("default_schema", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[4] = driverPropertyInfo;
        driverPropertyInfo = new DriverPropertyInfo("shutdown", null);
        driverPropertyInfo.value = properties.getProperty("shutdown", "false");
        driverPropertyInfo.required = false;
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfoArray[5] = driverPropertyInfo;
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 2;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    static {
        try {
            driverInstance = new JDBCDriver();
            DriverManager.registerDriver(driverInstance);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

