/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import java.io.IOException;
import org.hsqldb.Row;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class NodeAVLDisk
extends NodeAVL {
    final RowAVLDisk row;
    public int iData;
    private int iLeft = -1;
    private int iRight = -1;
    private int iParent = -1;
    private int iId;
    public static final int SIZE_IN_BYTE = 16;

    public NodeAVLDisk(RowAVLDisk rowAVLDisk, RowInputInterface rowInputInterface, int n) throws IOException {
        this.row = rowAVLDisk;
        this.iId = n;
        this.iData = rowAVLDisk.getPos();
        this.iBalance = rowInputInterface.readInt();
        this.iLeft = rowInputInterface.readInt();
        if (this.iLeft <= 0) {
            this.iLeft = -1;
        }
        this.iRight = rowInputInterface.readInt();
        if (this.iRight <= 0) {
            this.iRight = -1;
        }
        this.iParent = rowInputInterface.readInt();
        if (this.iParent <= 0) {
            this.iParent = -1;
        }
    }

    public NodeAVLDisk(RowAVLDisk rowAVLDisk, int n) {
        this.row = rowAVLDisk;
        this.iId = n;
        this.iData = rowAVLDisk.getPos();
    }

    public void delete() {
        this.iLeft = -1;
        this.iRight = -1;
        this.iParent = -1;
        this.nLeft = null;
        this.nRight = null;
        this.nParent = null;
        this.iBalance = 0;
        this.row.setNodesChanged();
    }

    public boolean isInMemory() {
        return this.row.isInMemory();
    }

    public boolean isMemory() {
        return false;
    }

    public int getPos() {
        return this.iData;
    }

    public Row getRow(PersistentStore persistentStore) {
        if (!this.row.isInMemory()) {
            return (RowAVLDisk)persistentStore.get(this.row, false);
        }
        this.row.updateAccessCount(persistentStore.getAccessCount());
        return this.row;
    }

    public Object[] getData(PersistentStore persistentStore) {
        return this.row.getData();
    }

    private NodeAVLDisk findNode(PersistentStore persistentStore, int n) {
        NodeAVLDisk nodeAVLDisk = null;
        RowAVLDisk rowAVLDisk = (RowAVLDisk)persistentStore.get(n, false);
        if (rowAVLDisk != null) {
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        return nodeAVLDisk;
    }

    boolean isLeft(NodeAVL nodeAVL) {
        if (nodeAVL == null) {
            return this.iLeft == -1;
        }
        return this.iLeft == ((NodeAVLDisk)nodeAVL).iData;
    }

    boolean isRight(NodeAVL nodeAVL) {
        if (nodeAVL == null) {
            return this.iRight == -1;
        }
        return this.iRight == ((NodeAVLDisk)nodeAVL).iData;
    }

    NodeAVL getLeft(PersistentStore persistentStore) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get(this.row, false);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDisk.iLeft == -1) {
            return null;
        }
        if (nodeAVLDisk.nLeft == null || !nodeAVLDisk.nLeft.isInMemory()) {
            nodeAVLDisk.nLeft = this.findNode(persistentStore, nodeAVLDisk.iLeft);
            nodeAVLDisk.nLeft.nParent = nodeAVLDisk;
        }
        return nodeAVLDisk.nLeft;
    }

    NodeAVL getRight(PersistentStore persistentStore) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get(this.row, false);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDisk.iRight == -1) {
            return null;
        }
        if (nodeAVLDisk.nRight == null || !nodeAVLDisk.nRight.isInMemory()) {
            nodeAVLDisk.nRight = this.findNode(persistentStore, nodeAVLDisk.iRight);
            nodeAVLDisk.nRight.nParent = nodeAVLDisk;
        }
        return nodeAVLDisk.nRight;
    }

    NodeAVL getParent(PersistentStore persistentStore) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get(this.row, false);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDisk.iParent == -1) {
            return null;
        }
        if (nodeAVLDisk.nParent == null || !nodeAVLDisk.nParent.isInMemory()) {
            nodeAVLDisk.nParent = this.findNode(persistentStore, this.iParent);
        }
        return nodeAVLDisk.nParent;
    }

    public int getBalance(PersistentStore persistentStore) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get(this.row, false);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        return nodeAVLDisk.iBalance;
    }

    boolean isRoot(PersistentStore persistentStore) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get(this.row, false);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        return nodeAVLDisk.iParent == -1;
    }

    boolean isFromLeft(PersistentStore persistentStore) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get(this.row, false);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDisk.iParent == -1) {
            return true;
        }
        if (nodeAVLDisk.nParent == null || !nodeAVLDisk.nParent.isInMemory()) {
            nodeAVLDisk.nParent = this.findNode(persistentStore, this.iParent);
        }
        return this.getPos() == ((NodeAVLDisk)nodeAVLDisk.nParent).iLeft;
    }

    public NodeAVL child(PersistentStore persistentStore, boolean bl) {
        return bl ? this.getLeft(persistentStore) : this.getRight(persistentStore);
    }

    NodeAVL setParent(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get(this.row, true);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (!rowAVLDisk.isInMemory()) {
            rowAVLDisk.keepInMemory(false);
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        rowAVLDisk.setNodesChanged();
        int n = nodeAVLDisk.iParent = nodeAVL == null ? -1 : nodeAVL.getPos();
        if (nodeAVL != null && !nodeAVL.isInMemory()) {
            nodeAVL = this.findNode(persistentStore, nodeAVL.getPos());
        }
        nodeAVLDisk.nParent = (NodeAVLDisk)nodeAVL;
        rowAVLDisk.keepInMemory(false);
        return nodeAVLDisk;
    }

    public NodeAVL setBalance(PersistentStore persistentStore, int n) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get(this.row, true);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (!rowAVLDisk.isInMemory()) {
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        rowAVLDisk.setNodesChanged();
        nodeAVLDisk.iBalance = n;
        rowAVLDisk.keepInMemory(false);
        return nodeAVLDisk;
    }

    NodeAVL setLeft(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get(this.row, true);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (!rowAVLDisk.isInMemory()) {
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        rowAVLDisk.setNodesChanged();
        int n = nodeAVLDisk.iLeft = nodeAVL == null ? -1 : nodeAVL.getPos();
        if (nodeAVL != null && !nodeAVL.isInMemory()) {
            nodeAVL = this.findNode(persistentStore, nodeAVL.getPos());
        }
        nodeAVLDisk.nLeft = (NodeAVLDisk)nodeAVL;
        rowAVLDisk.keepInMemory(false);
        return nodeAVLDisk;
    }

    NodeAVL setRight(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get(this.row, true);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (!rowAVLDisk.isInMemory()) {
            throw Error.runtimeError(201, "NodeAVLDisk");
        }
        rowAVLDisk.setNodesChanged();
        int n = nodeAVLDisk.iRight = nodeAVL == null ? -1 : nodeAVL.getPos();
        if (nodeAVL != null && !nodeAVL.isInMemory()) {
            nodeAVL = this.findNode(persistentStore, nodeAVL.getPos());
        }
        nodeAVLDisk.nRight = (NodeAVLDisk)nodeAVL;
        rowAVLDisk.keepInMemory(false);
        return nodeAVLDisk;
    }

    public NodeAVL set(PersistentStore persistentStore, boolean bl, NodeAVL nodeAVL) {
        NodeAVL nodeAVL2 = bl ? this.setLeft(persistentStore, nodeAVL) : this.setRight(persistentStore, nodeAVL);
        if (nodeAVL != null) {
            nodeAVL.setParent(persistentStore, this);
        }
        return nodeAVL2;
    }

    public void replace(PersistentStore persistentStore, Index index, NodeAVL nodeAVL) {
        NodeAVLDisk nodeAVLDisk = this;
        RowAVLDisk rowAVLDisk = this.row;
        if (!rowAVLDisk.keepInMemory(true)) {
            rowAVLDisk = (RowAVLDisk)persistentStore.get(this.row, true);
            nodeAVLDisk = (NodeAVLDisk)rowAVLDisk.getNode(this.iId);
        }
        if (nodeAVLDisk.iParent == -1) {
            if (nodeAVL != null) {
                nodeAVL = nodeAVL.setParent(persistentStore, null);
            }
            persistentStore.setAccessor(index, nodeAVL);
        } else {
            boolean bl = nodeAVLDisk.isFromLeft(persistentStore);
            nodeAVLDisk.getParent(persistentStore).set(persistentStore, bl, nodeAVL);
        }
        rowAVLDisk.keepInMemory(false);
    }

    boolean equals(NodeAVL nodeAVL) {
        if (nodeAVL instanceof NodeAVLDisk) {
            return this == nodeAVL || this.getPos() == ((NodeAVLDisk)nodeAVL).getPos();
        }
        return false;
    }

    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return 16;
    }

    public void setInMemory(boolean bl) {
        if (!bl) {
            if (this.nLeft != null) {
                this.nLeft.nParent = null;
            }
            if (this.nRight != null) {
                this.nRight.nParent = null;
            }
            if (this.nParent != null) {
                if (this.iData == ((NodeAVLDisk)this.nParent).iLeft) {
                    this.nParent.nLeft = null;
                } else {
                    this.nParent.nRight = null;
                }
            }
            this.nParent = null;
            this.nRight = null;
            this.nLeft = null;
        }
    }

    public void write(RowOutputInterface rowOutputInterface) {
        rowOutputInterface.writeInt(this.iBalance);
        rowOutputInterface.writeInt(this.iLeft == -1 ? 0 : this.iLeft);
        rowOutputInterface.writeInt(this.iRight == -1 ? 0 : this.iRight);
        rowOutputInterface.writeInt(this.iParent == -1 ? 0 : this.iParent);
    }

    public void write(RowOutputInterface rowOutputInterface, IntLookup intLookup) {
        rowOutputInterface.writeInt(this.iBalance);
        NodeAVLDisk.writeTranslatePointer(this.iLeft, rowOutputInterface, intLookup);
        NodeAVLDisk.writeTranslatePointer(this.iRight, rowOutputInterface, intLookup);
        NodeAVLDisk.writeTranslatePointer(this.iParent, rowOutputInterface, intLookup);
    }

    private static void writeTranslatePointer(int n, RowOutputInterface rowOutputInterface, IntLookup intLookup) {
        int n2 = 0;
        if (n != -1) {
            n2 = intLookup.lookupFirstEqual(n);
        }
        rowOutputInterface.writeInt(n2);
    }

    public void restore() {
    }

    public void destroy() {
    }

    public void updateAccessCount(int n) {
    }

    public int getAccessCount() {
        return 0;
    }

    public void setStorageSize(int n) {
    }

    public int getStorageSize() {
        return 0;
    }

    public void setPos(int n) {
    }

    public boolean hasChanged() {
        return false;
    }

    public boolean isKeepInMemory() {
        return false;
    }

    public boolean keepInMemory(boolean bl) {
        return false;
    }
}

