/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.api.reveng;

import org.hibernate.mapping.Table;

public class TableIdentifier {
    private final String catalog;
    private final String schema;
    private final String name;

    public static TableIdentifier create(Table table) {
        return new TableIdentifier(table.getCatalog(), table.getSchema(), table.getName());
    }

    public static TableIdentifier create(String catalog, String schema, String name) {
        return new TableIdentifier(catalog, schema, name);
    }

    private TableIdentifier(String catalog, String schema, String name) {
        this.catalog = catalog == null ? null : catalog.intern();
        this.schema = schema == null ? null : schema.intern();
        this.name = name == null ? null : name.intern();
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean equals(Object obj) {
        return obj instanceof TableIdentifier && this.equals((TableIdentifier)obj);
    }

    public boolean equals(TableIdentifier otherIdentifier) {
        if (otherIdentifier == null) {
            return false;
        }
        if (this == otherIdentifier) {
            return true;
        }
        if (this.equals(this.name, otherIdentifier.name) && this.equals(this.schema, otherIdentifier.schema)) {
            return this.equals(this.catalog, otherIdentifier.catalog);
        }
        return false;
    }

    public int hashCode() {
        int result = 13;
        result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 37 * result + (this.schema == null ? 0 : this.schema.hashCode());
        result = 37 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
        return result;
    }

    private boolean equals(String left, String right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append("TableIdentifier").append('(');
        if (this.getCatalog() != null) {
            buf.append(this.getCatalog() + ".");
        }
        if (this.getSchema() != null) {
            buf.append(this.getSchema() + ".");
        }
        buf.append(this.getName()).append(')');
        return buf.toString();
    }
}

