/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.time.ZoneOffset;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultZoneOffsetValueBridge
implements ValueBridge<ZoneOffset, Integer> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Integer toIndexedValue(ZoneOffset value, ValueBridgeToIndexedValueContext context) {
        return this.toIndexedValue(value);
    }

    @Override
    public ZoneOffset fromIndexedValue(Integer value, ValueBridgeFromIndexedValueContext context) {
        return value == null ? null : ZoneOffset.ofTotalSeconds(value);
    }

    @Override
    public Integer parse(String value) {
        return this.toIndexedValue(ParseUtils.parseZoneOffset((String)value));
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private Integer toIndexedValue(ZoneOffset value) {
        return value == null ? null : Integer.valueOf(value.getTotalSeconds());
    }
}

