/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.mapper.pojo.automaticindexing.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoImplicitReindexingResolverTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.AbstractPojoIndexingDependencyCollectorValueNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverValueNodeBuilderDelegate;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorPropertyNode;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.binding.impl.PojoModelPathBinder;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoIndexingDependencyCollectorValueNode<P, V>
extends AbstractPojoIndexingDependencyCollectorValueNode {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoIndexingDependencyCollectorPropertyNode<?, P> parentNode;
    private final BoundPojoModelPathValueNode<?, P, V> modelPathFromLastTypeNode;
    private final PojoModelPathValueNode unboundModelPathFromLastTypeNode;
    private final BoundPojoModelPathValueNode<?, P, V> modelPathFromLastEntityNode;
    private final ReindexOnUpdate reindexOnUpdate;
    private final Set<PojoModelPathValueNode> derivedFrom;
    private final Map<PojoRawTypeModel<?>, Map<PojoRawTypeModel<?>, PojoModelPathValueNode>> inverseAssociationPathCache = new HashMap();

    PojoIndexingDependencyCollectorValueNode(PojoIndexingDependencyCollectorPropertyNode<?, P> parentNode, BoundPojoModelPathValueNode<?, P, V> modelPathFromLastTypeNode, BoundPojoModelPathValueNode<?, P, V> modelPathFromLastEntityNode, PojoImplicitReindexingResolverBuildingHelper buildingHelper) {
        super(buildingHelper);
        this.parentNode = parentNode;
        this.modelPathFromLastTypeNode = modelPathFromLastTypeNode;
        this.unboundModelPathFromLastTypeNode = modelPathFromLastTypeNode.toUnboundPath();
        this.modelPathFromLastEntityNode = modelPathFromLastEntityNode;
        BoundPojoModelPathValueNode<?, P, V> modelPathValueNode = modelPathFromLastTypeNode;
        BoundPojoModelPath modelPathPropertyNode = modelPathFromLastTypeNode.getParent();
        BoundPojoModelPath modelPathTypeNode = ((BoundPojoModelPathPropertyNode)modelPathPropertyNode).getParent();
        ReindexOnUpdate metadataReindexOnUpdateOrNull = buildingHelper.getMetadataReindexOnUpdateOrNull(((BoundPojoModelPathTypeNode)modelPathTypeNode).getTypeModel(), ((BoundPojoModelPathPropertyNode)modelPathPropertyNode).getPropertyModel().name(), modelPathValueNode.getExtractorPath());
        this.reindexOnUpdate = parentNode.composeReindexOnUpdate(this.lastEntityNode(), metadataReindexOnUpdateOrNull);
        this.derivedFrom = buildingHelper.getMetadataDerivedFrom(((BoundPojoModelPathTypeNode)modelPathTypeNode).getTypeModel(), ((BoundPojoModelPathPropertyNode)modelPathPropertyNode).getPropertyModel().name(), modelPathValueNode.getExtractorPath());
    }

    public PojoIndexingDependencyCollectorTypeNode<V> type() {
        return new PojoIndexingDependencyCollectorTypeNode<V>(this, this.modelPathFromLastEntityNode.type(), this.buildingHelper);
    }

    public <U> PojoIndexingDependencyCollectorTypeNode<U> castedType(PojoRawTypeModel<U> typeModel) {
        return new PojoIndexingDependencyCollectorTypeNode(this, this.modelPathFromLastEntityNode.castedType(typeModel), this.buildingHelper);
    }

    public void collectDependency() {
        this.doCollectDependency(null);
    }

    @Override
    void collectDependency(BoundPojoModelPathValueNode<?, ?, ?> dirtyPathFromEntityType) {
        if (this.derivedFrom.isEmpty()) {
            this.parentNode.parentNode().collectDependency(dirtyPathFromEntityType);
        } else {
            this.collectDependency();
        }
    }

    void doCollectDependency(PojoIndexingDependencyCollectorValueNode<?, ?> initialNodeCollectingDependency) {
        ReindexOnUpdate composedReindexOnUpdate;
        ReindexOnUpdate reindexOnUpdate = composedReindexOnUpdate = initialNodeCollectingDependency == null ? this.reindexOnUpdate : initialNodeCollectingDependency.composeReindexOnUpdate(this.lastEntityNode(), this.reindexOnUpdate);
        if (ReindexOnUpdate.NO.equals((Object)composedReindexOnUpdate)) {
            return;
        }
        if (initialNodeCollectingDependency != null) {
            if (initialNodeCollectingDependency.unboundModelPathFromLastTypeNode.equals(this.unboundModelPathFromLastTypeNode)) {
                throw log.infiniteRecursionForDerivedFrom(this.modelPathFromLastTypeNode.getRootType().rawType(), this.modelPathFromLastTypeNode.toUnboundPath());
            }
        } else {
            initialNodeCollectingDependency = this;
        }
        if (this.derivedFrom.isEmpty()) {
            this.parentNode.parentNode().collectDependency(this.modelPathFromLastEntityNode);
        } else {
            PojoIndexingDependencyCollectorTypeNode<?> lastTypeNode = this.parentNode.parentNode();
            for (PojoModelPathValueNode path : this.derivedFrom) {
                PojoModelPathBinder.bind(lastTypeNode, path, PojoIndexingDependencyCollectorNode.walker(initialNodeCollectingDependency));
            }
        }
    }

    @Override
    PojoIndexingDependencyCollectorTypeNode<?> lastEntityNode() {
        return this.parentNode.lastEntityNode();
    }

    @Override
    ReindexOnUpdate reindexOnUpdate() {
        return this.reindexOnUpdate;
    }

    @Override
    void markForReindexing(AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> inverseSideEntityTypeNodeBuilder, BoundPojoModelPathValueNode<?, ?, ?> dependencyPathFromInverseSideEntityTypeNode) {
        PojoTypeModel<V> expectedInverseSideEntityType;
        PojoRawTypeModel<V> expectedInverseSideEntityRawType;
        PojoTypeModel<?> inverseSideEntityType = inverseSideEntityTypeNodeBuilder.getTypeModel();
        PojoRawTypeModel<?> inverseSideRawEntityType = inverseSideEntityType.rawType();
        if (!inverseSideRawEntityType.isSubTypeOf(expectedInverseSideEntityRawType = (expectedInverseSideEntityType = this.modelPathFromLastEntityNode.type().getTypeModel()).rawType())) {
            throw new AssertionFailure("Error while building the automatic reindexing resolver at path " + this.modelPathFromLastEntityNode + ": the dependency collector was passed a resolver builder with incorrect type;  got " + inverseSideRawEntityType + ", but a subtype of " + expectedInverseSideEntityRawType + " was expected.");
        }
        Map<PojoRawTypeModel<?>, PojoModelPathValueNode> inverseAssociationsPaths = this.getInverseAssociationPathByConcreteEntityType(inverseSideEntityTypeNodeBuilder.getTypeModel());
        for (Map.Entry<PojoRawTypeModel<?>, PojoModelPathValueNode> entry : inverseAssociationsPaths.entrySet()) {
            this.markForReindexingUsingAssociationInverseSideWithOriginalSideConcreteType((PojoTypeModel)entry.getKey(), inverseSideEntityTypeNodeBuilder, entry.getValue(), dependencyPathFromInverseSideEntityTypeNode);
        }
    }

    private Map<PojoRawTypeModel<?>, PojoModelPathValueNode> getInverseAssociationPathByConcreteEntityType(PojoTypeModel<?> inverseSideEntityType) {
        PojoRawTypeModel<?> inverseSideRawEntityType = inverseSideEntityType.rawType();
        Map<PojoRawTypeModel<Object>, PojoModelPathValueNode> result = this.inverseAssociationPathCache.get(inverseSideRawEntityType);
        if (result == null) {
            if (!this.inverseAssociationPathCache.containsKey(inverseSideRawEntityType)) {
                PojoTypeModel<?> originalSideEntityType = this.lastEntityNode().typeModel();
                PojoRawTypeModel<?> originalSideRawEntityType = originalSideEntityType.rawType();
                result = new LinkedHashMap();
                for (PojoRawTypeModel<?> concreteEntityType : this.buildingHelper.getConcreteEntitySubTypesForEntitySuperType(originalSideRawEntityType)) {
                    BoundPojoModelPathValueNode<?, ?, ?> modelPathFromConcreteEntitySubType = this.applyProcessingPathToSubType(concreteEntityType, this.modelPathFromLastEntityNode);
                    PojoModelPathValueNode inverseAssociationPath = this.buildingHelper.pathInverter().invertPath(inverseSideEntityType, modelPathFromConcreteEntitySubType).orElse(null);
                    if (inverseAssociationPath == null) {
                        throw log.cannotInvertAssociationForReindexing(inverseSideRawEntityType, concreteEntityType, this.modelPathFromLastEntityNode.toUnboundPath());
                    }
                    result.put(concreteEntityType, inverseAssociationPath);
                }
                this.inverseAssociationPathCache.put(inverseSideRawEntityType, result);
            } else {
                result = Collections.emptyMap();
            }
        }
        return result;
    }

    private void markForReindexingUsingAssociationInverseSideWithOriginalSideConcreteType(PojoTypeModel<?> originalSideConcreteEntityType, AbstractPojoImplicitReindexingResolverTypeNodeBuilder<?, ?> typeNodeBuilder, PojoModelPathValueNode inverseAssociationPath, BoundPojoModelPathValueNode<?, ?, ?> dependencyPathFromInverseSideEntityTypeNode) {
        Set<PojoRawTypeModel<?>> valueNodeTypeConcreteEntitySubTypes;
        PojoImplicitReindexingResolverValueNodeBuilderDelegate valueNodeBuilderDelegate;
        PojoTypeModel<?> inverseSideEntityType = typeNodeBuilder.getTypeModel();
        PojoRawTypeModel<?> inverseSideRawEntityType = inverseSideEntityType.rawType();
        PojoRawTypeModel<?> originalSideRawConcreteEntityType = originalSideConcreteEntityType.rawType();
        try {
            valueNodeBuilderDelegate = (PojoImplicitReindexingResolverValueNodeBuilderDelegate)PojoModelPathBinder.bind(typeNodeBuilder, inverseAssociationPath, PojoImplicitReindexingResolverBuilder.walker());
            PojoRawTypeModel inverseSideRawType = valueNodeBuilderDelegate.getTypeModel().rawType();
            valueNodeTypeConcreteEntitySubTypes = this.lastEntityNode().getConcreteEntitySubTypesForTypeToReindex(originalSideRawConcreteEntityType, inverseSideRawType);
        }
        catch (RuntimeException e) {
            throw log.cannotApplyImplicitInverseAssociationPath(inverseSideRawEntityType, inverseAssociationPath, originalSideRawConcreteEntityType, this.modelPathFromLastEntityNode.toUnboundPath(), e.getMessage(), e);
        }
        this.lastEntityNode().markForReindexing(valueNodeBuilderDelegate, valueNodeTypeConcreteEntitySubTypes, dependencyPathFromInverseSideEntityTypeNode);
    }

    private BoundPojoModelPathValueNode<?, ?, ?> applyProcessingPathToSubType(PojoRawTypeModel<?> rootSubType, BoundPojoModelPathValueNode<?, ?, ?> source) {
        return (BoundPojoModelPathValueNode)PojoModelPathBinder.bind(BoundPojoModelPath.root(rootSubType), source.toUnboundPath(), BoundPojoModelPath.walker(this.buildingHelper.extractorBinder()));
    }
}

