/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicClassPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicClassTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicDynamicMapPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicDynamicMapTypeMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmGenericTypeModelFactory;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmRawTypeIdentifierResolver;

public class HibernateOrmBasicTypeMetadataProvider {
    private final java.util.Map<String, PersistentClass> persistentClasses;
    private final java.util.Map<Class<?>, HibernateOrmBasicClassTypeMetadata> classTypeMetadata;
    private final java.util.Map<String, HibernateOrmBasicDynamicMapTypeMetadata> dynamicMapTypeMetadata;
    private final java.util.Map<String, String> jpaEntityNameToHibernateOrmEntityName;
    private final HibernateOrmRawTypeIdentifierResolver typeIdentifierResolver;

    public static HibernateOrmBasicTypeMetadataProvider create(Metadata metadata) {
        TreeSet<PersistentClass> persistentClasses = new TreeSet<PersistentClass>(Comparator.comparing(PersistentClass::getEntityName));
        persistentClasses.addAll(metadata.getEntityBindings());
        Builder builder = new Builder();
        for (PersistentClass persistentClass : persistentClasses) {
            HibernateOrmBasicTypeMetadataProvider.collectPersistentClass(builder, persistentClass);
        }
        return builder.build();
    }

    private static void collectPersistentClass(Builder metadataProviderBuilder, PersistentClass persistentClass) {
        String jpaEntityName = persistentClass.getJpaEntityName();
        String hibernateOrmEntityName = persistentClass.getEntityName();
        metadataProviderBuilder.persistentClasses.put(hibernateOrmEntityName, persistentClass);
        metadataProviderBuilder.jpaEntityNameToHibernateOrmEntityName.put(jpaEntityName, hibernateOrmEntityName);
        if (persistentClass.hasPojoRepresentation()) {
            Class javaClass = persistentClass.getMappedClass();
            HibernateOrmBasicTypeMetadataProvider.collectClassType(metadataProviderBuilder, javaClass, persistentClass.getIdentifierProperty(), persistentClass.getPropertyIterator());
            metadataProviderBuilder.typeIdentifierResolverBuilder.addClassEntityType(javaClass, jpaEntityName, hibernateOrmEntityName);
        } else {
            HibernateOrmBasicTypeMetadataProvider.collectDynamicMapType(metadataProviderBuilder, hibernateOrmEntityName, persistentClass.getSuperclass(), persistentClass.getIdentifierProperty(), persistentClass.getPropertyIterator());
            metadataProviderBuilder.typeIdentifierResolverBuilder.addDynamicMapEntityType(jpaEntityName, hibernateOrmEntityName);
        }
    }

    private static void collectClassType(Builder metadataProviderBuilder, Class<?> javaClass, Property identifierProperty, Iterator<Property> propertyIterator) {
        LinkedHashMap<String, HibernateOrmBasicClassPropertyMetadata> properties = new LinkedHashMap<String, HibernateOrmBasicClassPropertyMetadata>();
        if (identifierProperty != null) {
            HibernateOrmBasicTypeMetadataProvider.collectClassProperty(metadataProviderBuilder, properties, javaClass, identifierProperty, true);
        }
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.next();
            if (property.isSynthetic()) continue;
            HibernateOrmBasicTypeMetadataProvider.collectClassProperty(metadataProviderBuilder, properties, javaClass, property, false);
        }
        metadataProviderBuilder.classTypeMetadata.put(javaClass, new HibernateOrmBasicClassTypeMetadata(properties));
    }

    private static void collectDynamicMapType(Builder metadataProviderBuilder, String name, PersistentClass superClass, Property identifierProperty, Iterator<Property> propertyIterator) {
        String superEntityName = superClass == null ? null : superClass.getEntityName();
        LinkedHashMap<String, HibernateOrmBasicDynamicMapPropertyMetadata> properties = new LinkedHashMap<String, HibernateOrmBasicDynamicMapPropertyMetadata>();
        if (identifierProperty != null) {
            HibernateOrmBasicTypeMetadataProvider.collectDynamicMapProperty(metadataProviderBuilder, properties, identifierProperty);
        }
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.next();
            if (property.isSynthetic()) continue;
            HibernateOrmBasicTypeMetadataProvider.collectDynamicMapProperty(metadataProviderBuilder, properties, property);
        }
        metadataProviderBuilder.dynamicMapTypeMetadata.put(name, new HibernateOrmBasicDynamicMapTypeMetadata(superEntityName, properties));
    }

    private static void collectClassProperty(Builder metadataProviderBuilder, java.util.Map<String, HibernateOrmBasicClassPropertyMetadata> collectedProperties, Class<?> propertyHolderJavaClass, Property property, boolean isId) {
        try {
            Getter getter = property.getGetter(propertyHolderJavaClass);
            collectedProperties.put(property.getName(), new HibernateOrmBasicClassPropertyMetadata(getter.getMember(), isId));
        }
        catch (MappingException mappingException) {
            // empty catch block
        }
        HibernateOrmBasicTypeMetadataProvider.collectValue(metadataProviderBuilder, property.getValue());
    }

    private static void collectDynamicMapProperty(Builder metadataProviderBuilder, java.util.Map<String, HibernateOrmBasicDynamicMapPropertyMetadata> collectedProperties, Property property) {
        HibernateOrmGenericTypeModelFactory typeModelFactory = HibernateOrmBasicTypeMetadataProvider.collectValue(metadataProviderBuilder, property.getValue());
        collectedProperties.put(property.getName(), new HibernateOrmBasicDynamicMapPropertyMetadata(typeModelFactory));
    }

    private static HibernateOrmGenericTypeModelFactory collectValue(Builder metadataProviderBuilder, Value value) {
        if (value instanceof Component) {
            return HibernateOrmBasicTypeMetadataProvider.collectEmbedded(metadataProviderBuilder, (Component)value);
        }
        if (value instanceof Array) {
            Array array = (Array)value;
            return HibernateOrmGenericTypeModelFactory.array(HibernateOrmBasicTypeMetadataProvider.collectValue(metadataProviderBuilder, array.getElement()));
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return HibernateOrmGenericTypeModelFactory.map(map.getCollectionType().getReturnedClass(), HibernateOrmBasicTypeMetadataProvider.collectValue(metadataProviderBuilder, map.getIndex()), HibernateOrmBasicTypeMetadataProvider.collectValue(metadataProviderBuilder, map.getElement()));
        }
        if (value instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collection = (org.hibernate.mapping.Collection)value;
            return HibernateOrmGenericTypeModelFactory.collection(collection.getCollectionType().getReturnedClass(), HibernateOrmBasicTypeMetadataProvider.collectValue(metadataProviderBuilder, collection.getElement()));
        }
        if (value instanceof ToOne) {
            ToOne toOne = (ToOne)value;
            return HibernateOrmGenericTypeModelFactory.entityReference(toOne.getType().getReturnedClass(), toOne.getReferencedEntityName());
        }
        if (value instanceof OneToMany) {
            OneToMany oneToMany = (OneToMany)value;
            return HibernateOrmGenericTypeModelFactory.entityReference(oneToMany.getType().getReturnedClass(), oneToMany.getReferencedEntityName());
        }
        return HibernateOrmGenericTypeModelFactory.rawType(value.getType().getReturnedClass());
    }

    private static HibernateOrmGenericTypeModelFactory<?> collectEmbedded(Builder metadataProviderBuilder, Component component) {
        if (component.isDynamic()) {
            String name = component.getRoleName();
            if (!metadataProviderBuilder.dynamicMapTypeMetadata.containsKey(name)) {
                HibernateOrmBasicTypeMetadataProvider.collectDynamicMapType(metadataProviderBuilder, name, null, null, component.getPropertyIterator());
            }
            return HibernateOrmGenericTypeModelFactory.dynamicMap(name);
        }
        Class javaClass = component.getComponentClass();
        if (!metadataProviderBuilder.classTypeMetadata.containsKey(javaClass)) {
            HibernateOrmBasicTypeMetadataProvider.collectClassType(metadataProviderBuilder, javaClass, null, component.getPropertyIterator());
        }
        return HibernateOrmGenericTypeModelFactory.rawType(javaClass);
    }

    private HibernateOrmBasicTypeMetadataProvider(Builder builder) {
        this.persistentClasses = builder.persistentClasses;
        this.classTypeMetadata = builder.classTypeMetadata;
        this.dynamicMapTypeMetadata = builder.dynamicMapTypeMetadata;
        this.jpaEntityNameToHibernateOrmEntityName = builder.jpaEntityNameToHibernateOrmEntityName;
        this.typeIdentifierResolver = builder.typeIdentifierResolverBuilder.build();
    }

    public Collection<PersistentClass> getPersistentClasses() {
        return this.persistentClasses.values();
    }

    public PersistentClass getPersistentClass(String hibernateOrmEntityName) {
        return this.persistentClasses.get(hibernateOrmEntityName);
    }

    public HibernateOrmRawTypeIdentifierResolver getTypeIdentifierResolver() {
        return this.typeIdentifierResolver;
    }

    HibernateOrmBasicClassTypeMetadata getBasicClassTypeMetadata(Class<?> clazz) {
        return this.classTypeMetadata.get(clazz);
    }

    HibernateOrmBasicDynamicMapTypeMetadata getBasicDynamicMapTypeMetadata(String name) {
        return this.dynamicMapTypeMetadata.get(name);
    }

    public String getHibernateOrmEntityNameByJpaEntityName(String jpaEntityName) {
        return this.jpaEntityNameToHibernateOrmEntityName.get(jpaEntityName);
    }

    Set<String> getKnownDynamicMapTypeNames() {
        return this.dynamicMapTypeMetadata.keySet();
    }

    private static class Builder {
        private final java.util.Map<String, PersistentClass> persistentClasses = new LinkedHashMap<String, PersistentClass>();
        private final java.util.Map<Class<?>, HibernateOrmBasicClassTypeMetadata> classTypeMetadata = new LinkedHashMap();
        private final java.util.Map<String, HibernateOrmBasicDynamicMapTypeMetadata> dynamicMapTypeMetadata = new LinkedHashMap<String, HibernateOrmBasicDynamicMapTypeMetadata>();
        private final java.util.Map<String, String> jpaEntityNameToHibernateOrmEntityName = new LinkedHashMap<String, String>();
        private final HibernateOrmRawTypeIdentifierResolver.Builder typeIdentifierResolverBuilder = new HibernateOrmRawTypeIdentifierResolver.Builder();

        private Builder() {
        }

        HibernateOrmBasicTypeMetadataProvider build() {
            return new HibernateOrmBasicTypeMetadataProvider(this);
        }
    }
}

