/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.reporting.spi;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.reporting.impl.EngineEventContextMessages;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.EventContextElement;
import org.hibernate.search.util.common.reporting.impl.AbstractSimpleEventContextElement;

public class EventContexts {
    private static final EngineEventContextMessages MESSAGES = EngineEventContextMessages.INSTANCE;
    private static final EventContext DEFAULT = EventContexts.singleton(MESSAGES::defaultOnMissingContextElement);
    private static final EventContext DEFAULT_BACKEND = EventContexts.singleton(MESSAGES::defaultBackend);
    private static final EventContext INDEX_SCHEMA_ROOT = EventContexts.singleton(MESSAGES::indexSchemaRoot);

    private EventContexts() {
    }

    public static EventContext singleton(final Supplier<String> render) {
        return EventContext.create((EventContextElement)new EventContextElement(){

            public String toString() {
                return "EventContextElement[" + this.render() + "]";
            }

            public String render() {
                return (String)render.get();
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext defaultContext() {
        return DEFAULT;
    }

    public static EventContext indexSchemaRoot() {
        return INDEX_SCHEMA_ROOT;
    }

    public static EventContext fromType(MappableTypeModel typeModel) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<MappableTypeModel>(typeModel){

            public String render(MappableTypeModel param) {
                String typeName = param.name();
                return MESSAGES.type(typeName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromType(Object typeIdentifier) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<Object>(typeIdentifier){

            public String render(Object param) {
                String typeName = param.toString();
                return MESSAGES.type(typeName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext defaultBackend() {
        return DEFAULT_BACKEND;
    }

    public static EventContext fromBackendName(String name) {
        if (name == null) {
            return DEFAULT_BACKEND;
        }
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(name){

            public String render(String param) {
                return MESSAGES.backend(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromIndexName(String name) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(name){

            public String render(String param) {
                return MESSAGES.index(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromIndexNames(String ... indexNames) {
        return EventContexts.fromIndexNames(CollectionHelper.asLinkedHashSet((Object[])indexNames));
    }

    public static EventContext fromIndexNames(Set<String> indexNames) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<Set<String>>(indexNames){

            public String render(Set<String> indexNames) {
                return MESSAGES.indexes(indexNames);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromIndexNameAndShardId(String name, Optional<String> shardId) {
        EventContext result = EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(name){

            public String render(String param) {
                return MESSAGES.index(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
        if (shardId.isPresent()) {
            result = result.append(EventContexts.fromShardId(shardId.get()));
        }
        return result;
    }

    public static EventContext fromShardId(String shardId) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(shardId){

            public String render(String param) {
                return MESSAGES.shard(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromIndexFieldAbsolutePath(String absolutePath) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(absolutePath){

            public String render(String param) {
                return MESSAGES.indexFieldAbsolutePath(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromIndexFieldAbsolutePaths(List<String> absolutePaths) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<List<String>>(absolutePaths){

            public String render(List<String> param) {
                return MESSAGES.indexFieldAbsolutePaths(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromFieldTemplateAbsolutePath(String templateAbsolutePath) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(templateAbsolutePath){

            public String render(String param) {
                return MESSAGES.fieldTemplate(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromAnalyzer(String analyzerName) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(analyzerName){

            public String render(String param) {
                String analyzerName = param == null ? "" : param;
                return MESSAGES.analyzer(analyzerName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromNormalizer(String normalizerName) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(normalizerName){

            public String render(String param) {
                String normalizerName = param == null ? "" : param;
                return MESSAGES.normalizer(normalizerName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromCharFilter(String charFilterName) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(charFilterName){

            public String render(String param) {
                String charFilterName = param == null ? "" : param;
                return MESSAGES.charFilter(charFilterName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromTokenizer(String tokenizerName) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(tokenizerName){

            public String render(String param) {
                String tokenizerName = param == null ? "" : param;
                return MESSAGES.tokenizer(tokenizerName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromTokenFilter(String tokenFilterName) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(tokenFilterName){

            public String render(String param) {
                String tokenFilterName = param == null ? "" : param;
                return MESSAGES.tokenFilter(tokenFilterName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }
}

