/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.timing.spi;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import org.hibernate.search.engine.common.timing.spi.Deadline;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

final class StaticDeadline
implements Deadline {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final long remainingTimeMillis;

    StaticDeadline(long remainingTimeMillis) {
        this.remainingTimeMillis = remainingTimeMillis;
    }

    @Override
    public long remainingTimeMillis() {
        return this.remainingTimeMillis;
    }

    @Override
    public void forceTimeout(Exception cause) {
        throw this.forceTimeoutAndCreateException(cause);
    }

    @Override
    public SearchTimeoutException forceTimeoutAndCreateException(Exception cause) {
        return log.timedOut(Duration.ofMillis(this.remainingTimeMillis), cause);
    }
}

