/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.impl;

import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldTypeContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.backend.types.spi.AbstractIndexValueFieldType;

public final class LuceneIndexValueFieldType<F>
extends AbstractIndexValueFieldType<LuceneSearchIndexScope<?>, LuceneSearchIndexValueFieldContext<F>, F>
implements IndexFieldType<F>,
LuceneSearchIndexValueFieldTypeContext<F> {
    private final LuceneFieldCodec<F, ?> codec;
    private final Analyzer indexingAnalyzerOrNormalizer;
    private final Analyzer searchAnalyzerOrNormalizer;
    private final boolean hasTermVectorsConfigured;
    private final ProjectionConverter<?, ?> rawProjectionConverter;
    private final DslConverter<?, ?> rawDslConverter;

    private LuceneIndexValueFieldType(Builder<F> builder) {
        super(builder);
        this.codec = builder.codec;
        this.indexingAnalyzerOrNormalizer = builder.indexingAnalyzerOrNormalizer;
        this.searchAnalyzerOrNormalizer = builder.searchAnalyzerOrNormalizer;
        this.hasTermVectorsConfigured = builder.hasTermVectorsConfigured;
        this.rawProjectionConverter = ProjectionConverter.passThrough(this.codec.encodedType());
        this.rawDslConverter = DslConverter.passThrough(this.codec.encodedType());
    }

    @Override
    public LuceneFieldCodec<F, ?> codec() {
        return this.codec;
    }

    public Analyzer indexingAnalyzerOrNormalizer() {
        return this.indexingAnalyzerOrNormalizer;
    }

    @Override
    public Analyzer searchAnalyzerOrNormalizer() {
        return this.searchAnalyzerOrNormalizer;
    }

    @Override
    public boolean hasTermVectorsConfigured() {
        return this.hasTermVectorsConfigured;
    }

    public DslConverter<?, ?> rawDslConverter() {
        return this.rawDslConverter;
    }

    public ProjectionConverter<?, ?> rawProjectionConverter() {
        return this.rawProjectionConverter;
    }

    public static class Builder<F>
    extends AbstractIndexValueFieldType.Builder<LuceneSearchIndexScope<?>, LuceneSearchIndexValueFieldContext<F>, F> {
        private LuceneFieldCodec<F, ?> codec;
        private Analyzer indexingAnalyzerOrNormalizer;
        private Analyzer searchAnalyzerOrNormalizer;
        private boolean hasTermVectorsConfigured;

        public Builder(Class<F> valueClass) {
            super(valueClass);
        }

        public void codec(LuceneFieldCodec<F, ?> codec) {
            this.codec = codec;
        }

        public void indexingAnalyzerOrNormalizer(Analyzer analyzer) {
            this.indexingAnalyzerOrNormalizer = analyzer;
        }

        public Analyzer indexingAnalyzerOrNormalizer() {
            return this.indexingAnalyzerOrNormalizer;
        }

        public void searchAnalyzerOrNormalizer(Analyzer analyzer) {
            this.searchAnalyzerOrNormalizer = analyzer;
        }

        public void hasTermVectorsConfigured(boolean hasTermVectorsConfigured) {
            this.hasTermVectorsConfigured = hasTermVectorsConfigured;
        }

        public LuceneIndexValueFieldType<F> build() {
            return new LuceneIndexValueFieldType(this);
        }
    }
}

