/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.sort.impl;

import java.util.function.Function;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.sort.impl.AbstractLuceneSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.engine.search.common.NamedValues;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.SortFinalStep;
import org.hibernate.search.engine.search.sort.spi.WithParametersSortBuilder;

class LuceneWithParametersSort
extends AbstractLuceneSort {
    private final LuceneSearchIndexScope<?> scope;
    private final Function<? super NamedValues, ? extends SortFinalStep> sortCreator;

    LuceneWithParametersSort(Builder builder) {
        super(builder);
        this.scope = builder.scope;
        this.sortCreator = builder.sortCreator;
    }

    @Override
    public void toSortFields(LuceneSearchSortCollector collector) {
        SearchSort sort = this.sortCreator.apply((NamedValues)collector.toPredicateRequestContext(null).queryParameters()).toSort();
        LuceneSearchSort.from(this.scope, sort).toSortFields(collector);
    }

    static class Builder
    extends AbstractLuceneSort.AbstractBuilder
    implements WithParametersSortBuilder {
        private Function<? super NamedValues, ? extends SortFinalStep> sortCreator;

        Builder(LuceneSearchIndexScope<?> scope) {
            super(scope);
        }

        public void creator(Function<? super NamedValues, ? extends SortFinalStep> sortCreator) {
            this.sortCreator = sortCreator;
        }

        public SearchSort build() {
            return new LuceneWithParametersSort(this);
        }
    }
}

