/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCompositeNodeSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.definition.PredicateDefinition;
import org.hibernate.search.engine.search.predicate.definition.PredicateDefinitionContext;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.spi.NamedPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.NamedValuesBasedPredicateDefinitionContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneNamedPredicate
extends AbstractLuceneSingleFieldPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneSearchPredicate instance;

    private LuceneNamedPredicate(Builder builder, LuceneSearchPredicate providedPredicate) {
        super(builder);
        this.instance = providedPredicate;
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
        this.instance.checkNestableWithin(expectedParentNestedPath);
        super.checkNestableWithin(expectedParentNestedPath);
    }

    @Override
    protected Query doToQuery(PredicateRequestContext context) {
        return this.instance.toQuery(context);
    }

    private static class Builder
    extends AbstractLuceneSingleFieldPredicate.AbstractBuilder
    implements NamedPredicateBuilder {
        private final PredicateDefinition definition;
        private final String predicateName;
        private final LuceneSearchIndexCompositeNodeContext field;
        private SearchPredicateFactory factory;
        private final Map<String, Object> params = new LinkedHashMap<String, Object>();

        Builder(PredicateDefinition definition, String predicateName, LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            super(scope, node);
            this.definition = definition;
            this.predicateName = predicateName;
            this.field = node;
        }

        public void factory(SearchPredicateFactory factory) {
            this.factory = factory;
        }

        public void param(String name, Object value) {
            this.params.put(name, value);
        }

        public SearchPredicate build() {
            NamedValuesBasedPredicateDefinitionContext ctx = new NamedValuesBasedPredicateDefinitionContext(this.factory, this.params, name -> log.paramNotDefined((String)name, this.predicateName, this.field.eventContext()));
            LuceneSearchPredicate providedPredicate = LuceneSearchPredicate.from(this.scope, this.definition.create((PredicateDefinitionContext)ctx));
            return new LuceneNamedPredicate(this, providedPredicate);
        }
    }

    public static class Factory
    extends AbstractLuceneCompositeNodeSearchQueryElementFactory<NamedPredicateBuilder> {
        private final PredicateDefinition definition;
        private final String predicateName;

        public Factory(PredicateDefinition definition, String predicateName) {
            this.definition = definition;
            this.predicateName = predicateName;
        }

        @Override
        public void checkCompatibleWith(SearchQueryElementFactory<?, ?, ?> other) {
            super.checkCompatibleWith(other);
            Factory castedOther = (Factory)other;
            if (!this.definition.equals((Object)castedOther.definition)) {
                throw log.differentPredicateDefinitionForQueryElement(this.definition, castedOther.definition);
            }
        }

        public NamedPredicateBuilder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            return new Builder(this.definition, this.predicateName, scope, node);
        }
    }
}

