/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.extraction.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldCollectorManager;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.search.TotalHitCountCollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.StoredFieldsValuesDelegate;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;
import org.hibernate.search.backend.lucene.search.extraction.impl.HibernateSearchMultiCollectorManager;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneCollectors;
import org.hibernate.search.backend.lucene.search.extraction.impl.ReusableDocumentStoredFieldVisitor;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public final class ExtractionRequirements {
    private final boolean requireScore;
    private final Set<CollectorFactory<?, ?, ?>> requiredCollectorForAllMatchingDocsFactories;
    private final StoredFieldsValuesDelegate.Factory storedFieldsSourceFactoryOrNull;

    private ExtractionRequirements(Builder builder) {
        this.requireScore = builder.requireScore;
        this.requiredCollectorForAllMatchingDocsFactories = builder.requiredCollectorForAllMatchingDocsFactories;
        this.storedFieldsSourceFactoryOrNull = builder.createStoredFieldsSourceFactoryOrNull();
    }

    public LuceneCollectors createCollectors(IndexSearcher indexSearcher, Query originalLuceneQuery, Sort sort, IndexReaderMetadataResolver metadataResolver, int maxDocs, int offset, TimeoutManager timeoutManager, int requestedTotalHitCountThreshold) throws IOException {
        Query rewrittenLuceneQuery = indexSearcher.rewrite(originalLuceneQuery);
        int totalHitCountThreshold = rewrittenLuceneQuery instanceof MatchAllDocsQuery ? 0 : requestedTotalHitCountThreshold;
        Object topDocsCollectorManager = null;
        Integer scoreSortFieldIndexForRescoring = null;
        boolean requireFieldDocRescoring = false;
        CollectorExecutionContext executionContext = new CollectorExecutionContext(metadataResolver, indexSearcher, maxDocs);
        HibernateSearchMultiCollectorManager.Builder collectorsForAllMatchingDocsBuilder = new HibernateSearchMultiCollectorManager.Builder(executionContext, timeoutManager);
        if (maxDocs > 0) {
            if (sort == null || this.isDescendingScoreSort(sort)) {
                topDocsCollectorManager = new HibernateSearchTopScoreDocCollectorManager(offset, maxDocs, null, totalHitCountThreshold, true);
            } else {
                if (this.requireScore) {
                    requireFieldDocRescoring = true;
                    scoreSortFieldIndexForRescoring = this.getScoreSortFieldIndexOrNull(sort);
                }
                topDocsCollectorManager = new HibernateSearchTopFieldCollectorManager(offset, sort, maxDocs, null, totalHitCountThreshold, true);
            }
            collectorsForAllMatchingDocsBuilder.add(LuceneCollectors.TOP_DOCS_KEY, topDocsCollectorManager);
        }
        if (topDocsCollectorManager == null && totalHitCountThreshold > 0) {
            TotalHitCountCollectorManager totalHitCountCollectorManager = new TotalHitCountCollectorManager();
            collectorsForAllMatchingDocsBuilder.add(LuceneCollectors.TOTAL_HIT_COUNT_KEY, totalHitCountCollectorManager);
        }
        collectorsForAllMatchingDocsBuilder.addAll(this.requiredCollectorForAllMatchingDocsFactories);
        HibernateSearchMultiCollectorManager collectorManager = collectorsForAllMatchingDocsBuilder.build();
        return new LuceneCollectors(metadataResolver, indexSearcher, rewrittenLuceneQuery, originalLuceneQuery, requireFieldDocRescoring, scoreSortFieldIndexForRescoring, collectorManager, this.storedFieldsSourceFactoryOrNull, timeoutManager);
    }

    private boolean isDescendingScoreSort(Sort sort) {
        SortField[] fields = sort.getSort();
        return fields.length == 1 && this.isDescendingScoreSort(fields[0]);
    }

    private boolean isDescendingScoreSort(SortField sortField) {
        return SortField.Type.SCORE == sortField.getType() && !sortField.getReverse();
    }

    private Integer getScoreSortFieldIndexOrNull(Sort sort) {
        SortField[] sortFields = sort.getSort();
        for (int i = 0; i < sortFields.length; ++i) {
            SortField sortField = sortFields[i];
            if (sortField.getType() != SortField.Type.SCORE) continue;
            return i;
        }
        return null;
    }

    public static class Builder {
        private boolean requireScore;
        private final Set<CollectorFactory<?, ?, ?>> requiredCollectorForAllMatchingDocsFactories = new LinkedHashSet();
        private boolean requireAllStoredFields = false;
        private final Set<String> requiredStoredFields = new HashSet<String>();
        private final Set<String> requiredNestedDocumentPathsForStoredFields = new HashSet<String>();

        public void requireScore() {
            this.requireScore = true;
        }

        public <C extends Collector, T, CM extends CollectorManager<C, T>> void requireCollectorForAllMatchingDocs(CollectorFactory<C, T, CM> collectorFactory) {
            this.requiredCollectorForAllMatchingDocsFactories.add(collectorFactory);
        }

        public void requireAllStoredFields() {
            this.requireAllStoredFields = true;
            this.requiredStoredFields.clear();
        }

        public void requireNestedObjects(Collection<String> paths) {
            this.requiredNestedDocumentPathsForStoredFields.addAll(paths);
        }

        public void requireStoredField(String absoluteFieldPath, String nestedDocumentPath) {
            if (!this.requireAllStoredFields) {
                this.requiredStoredFields.add(absoluteFieldPath);
            }
            if (nestedDocumentPath != null) {
                this.requiredNestedDocumentPathsForStoredFields.add(nestedDocumentPath);
            }
        }

        public ExtractionRequirements build() {
            return new ExtractionRequirements(this);
        }

        private StoredFieldsValuesDelegate.Factory createStoredFieldsSourceFactoryOrNull() {
            ReusableDocumentStoredFieldVisitor storedFieldVisitor;
            if (this.requireAllStoredFields) {
                storedFieldVisitor = new ReusableDocumentStoredFieldVisitor();
            } else if (!this.requiredStoredFields.isEmpty()) {
                storedFieldVisitor = new ReusableDocumentStoredFieldVisitor(this.requiredStoredFields);
            } else {
                return null;
            }
            return new StoredFieldsValuesDelegate.Factory(storedFieldVisitor, this.requiredNestedDocumentPathsForStoredFields);
        }
    }

    private static final class HibernateSearchTopScoreDocCollectorManager
    extends TopScoreDocCollectorManager {
        private final int numHits;
        private final int offset;

        public HibernateSearchTopScoreDocCollectorManager(int offset, int numHits, ScoreDoc after, int totalHitsThreshold, boolean supportsConcurrency) {
            super(numHits, after, totalHitsThreshold, supportsConcurrency);
            this.numHits = numHits;
            this.offset = offset;
        }

        public TopDocs reduce(Collection<TopScoreDocCollector> collectors) {
            TopDocs[] topDocs = new TopDocs[collectors.size()];
            int i = 0;
            for (TopScoreDocCollector collector : collectors) {
                topDocs[i++] = collector.topDocs();
            }
            return TopDocs.merge((int)this.offset, (int)this.numHits, (TopDocs[])topDocs);
        }
    }

    private static final class HibernateSearchTopFieldCollectorManager
    extends TopFieldCollectorManager {
        private final int numHits;
        private final Sort sort;
        private final int offset;

        public HibernateSearchTopFieldCollectorManager(int offset, Sort sort, int numHits, FieldDoc after, int totalHitsThreshold, boolean supportsConcurrency) {
            super(sort, numHits, after, totalHitsThreshold, supportsConcurrency);
            this.numHits = numHits;
            this.offset = offset;
            this.sort = sort;
        }

        public TopFieldDocs reduce(Collection<TopFieldCollector> collectors) {
            TopFieldDocs[] topDocs = new TopFieldDocs[collectors.size()];
            int i = 0;
            for (TopFieldCollector collector : collectors) {
                topDocs[i++] = collector.topDocs();
            }
            return TopDocs.merge((Sort)this.sort, (int)this.offset, (int)this.numHits, (TopFieldDocs[])topDocs);
        }
    }
}

