/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.index.impl.LuceneIndexManagerImpl;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.scope.impl.LuceneIndexScopeImpl;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneIndexScopeBuilder
implements IndexScopeBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexManagerBackendContext backendContext;
    private final BackendMappingContext mappingContext;
    private final Set<LuceneIndexManagerImpl> indexManagers = new LinkedHashSet<LuceneIndexManagerImpl>();

    LuceneIndexScopeBuilder(IndexManagerBackendContext backendContext, BackendMappingContext mappingContext, LuceneIndexManagerImpl indexManager) {
        this.backendContext = backendContext;
        this.mappingContext = mappingContext;
        this.indexManagers.add(indexManager);
    }

    void add(IndexManagerBackendContext backendContext, LuceneIndexManagerImpl indexManager) {
        if (!this.backendContext.equals(backendContext)) {
            throw log.cannotMixLuceneScopeWithOtherBackend(this, indexManager, backendContext.getEventContext());
        }
        this.indexManagers.add(indexManager);
    }

    public IndexScope build() {
        return new LuceneIndexScopeImpl(this.backendContext, this.mappingContext, this.indexManagers);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "backendContext=" + this.backendContext + ", indexManagers=" + this.indexManagers + "]";
    }
}

