/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningTextMultiValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.facet.impl.TextMultiValueFacetCounts;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneFacetsBasedTermsAggregation;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.util.common.reporting.spi.EventContextProvider;

public class LuceneTextTermsAggregation<K>
extends AbstractLuceneFacetsBasedTermsAggregation<String, String, K, String> {
    private static final Comparator<String> STRING_COMPARATOR = Comparator.naturalOrder();

    private LuceneTextTermsAggregation(Builder<K> builder) {
        super(builder);
    }

    @Override
    protected LuceneSearchAggregation.Extractor<Map<K, Long>> extractor(AggregationRequestContext context) {
        return new LuceneTextTermsAggregationExtractor();
    }

    private class LuceneTextTermsAggregationExtractor
    extends AbstractLuceneFacetsBasedTermsAggregation.AbstractExtractor {
        private LuceneTextTermsAggregationExtractor() {
        }

        @Override
        FacetResult getTopChildren(IndexReader reader, FacetsCollector facetsCollector, NestedDocsProvider nestedDocsProvider, int limit) throws IOException {
            JoiningTextMultiValuesSource valueSource = JoiningTextMultiValuesSource.fromField(LuceneTextTermsAggregation.this.absoluteFieldPath, nestedDocsProvider);
            TextMultiValueFacetCounts facetCounts = new TextMultiValueFacetCounts(reader, LuceneTextTermsAggregation.this.absoluteFieldPath, valueSource, facetsCollector);
            return facetCounts.getTopChildren(limit, LuceneTextTermsAggregation.this.absoluteFieldPath, new String[0]);
        }

        Set<String> collectFirstTerms(IndexReader reader, boolean descending, int limit) throws IOException {
            TreeSet<String> collectedTerms = new TreeSet<String>(descending ? STRING_COMPARATOR.reversed() : STRING_COMPARATOR);
            for (LeafReaderContext leaf : reader.leaves()) {
                int i;
                LeafReader atomicReader = leaf.reader();
                SortedSetDocValues docValues = atomicReader.getSortedSetDocValues(LuceneTextTermsAggregation.this.absoluteFieldPath);
                if (docValues == null) continue;
                int valueCount = (int)docValues.getValueCount();
                if (descending) {
                    int start;
                    for (i = start = Math.max(0, valueCount - limit); i < valueCount; ++i) {
                        collectedTerms.add(docValues.lookupOrd((long)i).utf8ToString());
                    }
                    continue;
                }
                int end = Math.min(limit, valueCount);
                for (i = 0; i < end; ++i) {
                    collectedTerms.add(docValues.lookupOrd((long)i).utf8ToString());
                }
            }
            return collectedTerms;
        }

        Comparator<String> getAscendingTermComparator() {
            return STRING_COMPARATOR;
        }

        String labelToTerm(String label) {
            return label;
        }

        String termToFieldValue(String key) {
            return key;
        }
    }

    private static class Builder<K>
    extends AbstractLuceneFacetsBasedTermsAggregation.AbstractBuilder<String, String, K, String> {
        private Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<String> field, ProjectionConverter<String, ? extends K> fromFieldValueConverter) {
            super(scope, field, fromFieldValueConverter);
        }

        @Override
        public LuceneTextTermsAggregation<K> build() {
            return new LuceneTextTermsAggregation(this);
        }
    }

    private static class TypeSelector
    extends AbstractLuceneFacetsBasedTermsAggregation.AbstractTypeSelector<String, String> {
        private TypeSelector(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<String> field) {
            super(scope, field);
        }

        public <K> Builder<K> type(Class<K> expectedType, ValueModel valueModel) {
            if (ValueModel.RAW.equals((Object)valueModel)) {
                return new Builder((LuceneSearchIndexScope<?>)this.scope, this.field, this.field.type().rawProjectionConverter().withConvertedType(expectedType, (EventContextProvider)this.field));
            }
            return new Builder((LuceneSearchIndexScope<?>)this.scope, this.field, this.field.type().projectionConverter(valueModel).withConvertedType(expectedType, (EventContextProvider)this.field));
        }
    }

    public static class Factory
    extends AbstractLuceneValueFieldSearchQueryElementFactory<TermsAggregationBuilder.TypeSelector, String> {
        @Override
        public TypeSelector create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<String> field) {
            return new TypeSelector(scope, field);
        }
    }
}

