/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReaderContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.StoredFieldsValuesDelegate;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.reporting.impl.LuceneSearchHints;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneProjectionTypeKeys;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;

class LuceneDocumentProjection
extends AbstractLuceneProjection<Document>
implements LuceneSearchProjection.Extractor<Document, Document> {
    LuceneDocumentProjection(LuceneSearchIndexScope<?> scope) {
        super(scope);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public LuceneSearchProjection.Extractor<?, Document> request(ProjectionRequestContext context) {
        context.checkNotNested(LuceneProjectionTypeKeys.DOCUMENT, LuceneSearchHints.INSTANCE.documentProjectionNestingNotSupportedHint());
        context.requireAllStoredFields();
        return this;
    }

    @Override
    public Values<Document> values(ProjectionExtractContext context) {
        final StoredFieldsValuesDelegate delegate = context.collectorExecutionContext().storedFieldsValuesDelegate();
        return new Values<Document>(){

            @Override
            public void context(LeafReaderContext context) {
            }

            @Override
            public Document get(int doc) {
                return delegate.get(doc);
            }
        };
    }

    @Override
    public Document transform(LoadingResult<?> loadingResult, Document extractedData, ProjectionTransformContext context) {
        return extractedData;
    }
}

