/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.lucene.util.BitSet;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TopDocsDataCollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.Values;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCompositeNodeSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractNestingAwareAccumulatingValues;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneSearchProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.engine.search.projection.spi.ProjectionCompositor;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;
import org.hibernate.search.util.common.SearchException;

public class LuceneObjectProjection<E, V, P>
extends AbstractLuceneProjection<P> {
    private final String absoluteFieldPath;
    private final boolean nested;
    private final Query filter;
    private final String nestedDocumentPath;
    private final String requiredContextAbsoluteFieldPath;
    private final LuceneSearchProjection<?>[] inners;
    private final ProjectionCompositor<E, V> compositor;
    private final ProjectionAccumulator.Provider<V, P> accumulatorProvider;

    public LuceneObjectProjection(Builder builder, LuceneSearchProjection<?>[] inners, ProjectionCompositor<E, V> compositor, ProjectionAccumulator.Provider<V, P> accumulatorProvider) {
        super(builder.scope);
        this.absoluteFieldPath = builder.objectField.absolutePath();
        this.nested = builder.objectField.type().nested();
        this.filter = builder.filter;
        this.nestedDocumentPath = builder.objectField.nestedDocumentPath();
        this.requiredContextAbsoluteFieldPath = accumulatorProvider.isSingleValued() ? builder.objectField.closestMultiValuedParentAbsolutePath() : null;
        this.inners = inners;
        this.compositor = compositor;
        this.accumulatorProvider = accumulatorProvider;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[inners=" + Arrays.toString(this.inners) + ", compositor=" + this.compositor + ", accumulatorProvider=" + this.accumulatorProvider + "]";
    }

    @Override
    public LuceneSearchProjection.Extractor<?, P> request(ProjectionRequestContext context) {
        ProjectionRequestContext innerContext = context.forField(this.absoluteFieldPath, this.nested);
        if (this.requiredContextAbsoluteFieldPath != null && !this.requiredContextAbsoluteFieldPath.equals(context.absoluteCurrentNestedFieldPath())) {
            throw log.invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(this.absoluteFieldPath, this.requiredContextAbsoluteFieldPath);
        }
        LuceneSearchProjection.Extractor[] innerExtractors = new LuceneSearchProjection.Extractor[this.inners.length];
        for (int i = 0; i < this.inners.length; ++i) {
            innerExtractors[i] = this.inners[i].request(innerContext);
        }
        return new ObjectFieldExtractor(context.absoluteCurrentNestedFieldPath(), innerExtractors, this.accumulatorProvider.get());
    }

    static class Builder
    implements CompositeProjectionBuilder {
        private final LuceneSearchIndexScope<?> scope;
        private final LuceneSearchIndexCompositeNodeContext objectField;
        private final Query filter;

        Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext objectField, Query filter) {
            this.scope = scope;
            this.objectField = objectField;
            this.filter = filter;
        }

        public <E, V, P> SearchProjection<P> build(SearchProjection<?>[] inners, ProjectionCompositor<E, V> compositor, ProjectionAccumulator.Provider<V, P> accumulatorProvider) {
            if (accumulatorProvider.isSingleValued() && this.objectField.multiValued()) {
                throw LuceneSearchProjection.log.invalidSingleValuedProjectionOnMultiValuedField(this.objectField.absolutePath(), this.objectField.eventContext());
            }
            LuceneSearchProjection[] typedInners = new LuceneSearchProjection[inners.length];
            for (int i = 0; i < inners.length; ++i) {
                typedInners[i] = LuceneSearchProjection.from(this.scope, inners[i]);
            }
            return new LuceneObjectProjection<E, V, P>(this, typedInners, compositor, accumulatorProvider);
        }
    }

    private class ObjectFieldExtractor<A>
    implements LuceneSearchProjection.Extractor<A, P> {
        private final String contextAbsoluteFieldPath;
        private final LuceneSearchProjection.Extractor<?, ?>[] inners;
        private final ProjectionAccumulator<E, V, A, P> accumulator;

        private ObjectFieldExtractor(String contextAbsoluteFieldPath, LuceneSearchProjection.Extractor<?, ?>[] inners, ProjectionAccumulator<E, V, A, P> accumulator) {
            this.contextAbsoluteFieldPath = contextAbsoluteFieldPath;
            this.inners = inners;
            this.accumulator = accumulator;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[inners=" + Arrays.toString(this.inners) + ", compositor=" + LuceneObjectProjection.this.compositor + ", accumulator=" + this.accumulator + "]";
        }

        @Override
        public Values<A> values(ProjectionExtractContext context) {
            Values[] innerValues = new Values[this.inners.length];
            for (int i = 0; i < this.inners.length; ++i) {
                innerValues[i] = this.inners[i].values(context);
            }
            return new ObjectFieldValues(context.collectorExecutionContext(), innerValues);
        }

        @Override
        public final P transform(LoadingResult<?> loadingResult, A accumulated, ProjectionTransformContext context) {
            for (int i = 0; i < this.accumulator.size(accumulated); ++i) {
                Object transformedData = this.accumulator.get(accumulated, i);
                for (int j = 0; j < this.inners.length; ++j) {
                    Object extractedDataForInner = LuceneObjectProjection.this.compositor.get(transformedData, j);
                    Object transformedDataForInner = LuceneSearchProjection.Extractor.transformUnsafe(this.inners[j], loadingResult, extractedDataForInner, context);
                    transformedData = LuceneObjectProjection.this.compositor.set(transformedData, j, transformedDataForInner);
                }
                accumulated = this.accumulator.transform(accumulated, i, LuceneObjectProjection.this.compositor.finish(transformedData));
            }
            return this.accumulator.finish(accumulated);
        }

        private class ObjectFieldValues
        extends AbstractNestingAwareAccumulatingValues<E, A> {
            private final Values<?>[] inners;
            private final QueryBitSetProducer filterBitSetProducer;
            private BitSet filterMatchedBitSet;

            private ObjectFieldValues(TopDocsDataCollectorExecutionContext context, Values<?>[] inners) {
                super(ObjectFieldExtractor.this.contextAbsoluteFieldPath, LuceneObjectProjection.this.nestedDocumentPath, ObjectFieldExtractor.this.accumulator, context);
                this.inners = inners;
                this.filterBitSetProducer = LuceneObjectProjection.this.filter == null ? null : new QueryBitSetProducer(LuceneObjectProjection.this.filter);
            }

            @Override
            public void context(LeafReaderContext context) throws IOException {
                super.context(context);
                if (this.filterBitSetProducer != null) {
                    this.filterMatchedBitSet = this.filterBitSetProducer.getBitSet(context);
                }
                for (Values<?> inner : this.inners) {
                    inner.context(context);
                }
            }

            @Override
            protected A accumulate(A accumulated, int docId) throws IOException {
                if (!(this.filterBitSetProducer == null || this.filterMatchedBitSet != null && this.filterMatchedBitSet.get(docId))) {
                    return accumulated;
                }
                Object components = LuceneObjectProjection.this.compositor.createInitial();
                for (int i = 0; i < this.inners.length; ++i) {
                    Object extractedDataForInner = this.inners[i].get(docId);
                    components = LuceneObjectProjection.this.compositor.set(components, i, extractedDataForInner);
                }
                return this.accumulator.accumulate(accumulated, components);
            }
        }
    }

    public static class Factory
    extends AbstractLuceneCompositeNodeSearchQueryElementFactory<Builder> {
        public Builder create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexCompositeNodeContext node) {
            Query filter = null;
            if (!node.type().nested()) {
                if (node.multiValued()) {
                    throw node.cannotUseQueryElement(ProjectionTypeKeys.OBJECT, LuceneSearchProjection.log.missingSupportHintForObjectProjectionOnMultiValuedFlattenedObjectNode(), null);
                }
                try {
                    filter = LuceneSearchPredicate.from(scope, ((ExistsPredicateBuilder)node.queryElement(PredicateTypeKeys.EXISTS, scope)).build()).toQuery(PredicateRequestContext.root());
                }
                catch (SearchException e) {
                    throw node.cannotUseQueryElement(ProjectionTypeKeys.OBJECT, e.getMessage(), (Exception)((Object)e));
                }
            }
            if (node.multiValued() && !node.type().nested()) {
                throw node.cannotUseQueryElement(ProjectionTypeKeys.OBJECT, LuceneSearchProjection.log.missingSupportHintForObjectProjectionOnMultiValuedFlattenedObjectNode(), null);
            }
            return new Builder(scope, node, filter);
        }
    }
}

