/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.Loader;
import org.hibernate.search.engine.SearchFactoryImplementor;

public class QueryLoader
implements Loader {
    private static final int MAX_IN_CLAUSE = 500;
    private static final List EMPTY_LIST = new ArrayList(0);
    private static Log log = LogFactory.getLog(QueryLoader.class);
    private Session session;
    private Class entityType;
    private SearchFactoryImplementor searchFactoryImplementor;
    private Criteria criteria;

    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor) {
        this.session = session;
        this.searchFactoryImplementor = searchFactoryImplementor;
    }

    public void setEntityType(Class entityType) {
        this.entityType = entityType;
    }

    public Object load(EntityInfo entityInfo) {
        Object maybeProxy = this.session.get(entityInfo.clazz, entityInfo.id);
        try {
            Hibernate.initialize((Object)maybeProxy);
        }
        catch (ObjectNotFoundException e) {
            log.debug((Object)("Object found in Search index but not in database: " + e.getEntityName() + " wih id " + e.getIdentifier()));
            maybeProxy = null;
        }
        return maybeProxy;
    }

    public List load(EntityInfo ... entityInfos) {
        boolean exact;
        int maxResults = entityInfos.length;
        if (maxResults == 0) {
            return EMPTY_LIST;
        }
        if (this.entityType == null) {
            throw new AssertionFailure("EntityType not defined");
        }
        if (this.criteria == null) {
            this.criteria = this.session.createCriteria(this.entityType);
        }
        DocumentBuilder<Object> builder = this.searchFactoryImplementor.getDocumentBuilders().get(this.entityType);
        String idName = builder.getIdentifierName();
        int loop = maxResults / 500;
        boolean bl = exact = maxResults % 500 == 0;
        if (!exact) {
            ++loop;
        }
        Disjunction disjunction = Restrictions.disjunction();
        for (int index = 0; index < loop; ++index) {
            int max = index * 500 + 500 <= maxResults ? index * 500 + 500 : maxResults;
            ArrayList<Serializable> ids = new ArrayList<Serializable>(max - index * 500);
            for (int entityInfoIndex = index * 500; entityInfoIndex < max; ++entityInfoIndex) {
                ids.add(entityInfos[entityInfoIndex].id);
            }
            disjunction.add(Restrictions.in((String)idName, ids));
        }
        this.criteria.add((Criterion)disjunction);
        this.criteria.list();
        ArrayList<Object> result = new ArrayList<Object>(entityInfos.length);
        for (EntityInfo entityInfo : entityInfos) {
            Object element = this.session.load(entityInfo.clazz, entityInfo.id);
            if (!Hibernate.isInitialized((Object)element)) continue;
            result.add(element);
        }
        return result;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }
}

