/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hibernate.Hibernate;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.QueueingProcessor;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkQueue;
import org.hibernate.search.backend.impl.jms.JMSBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessorFactory;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.SearchFactoryImplementor;

public class BatchedQueueingProcessor
implements QueueingProcessor {
    private boolean sync;
    private int batchSize;
    private ExecutorService executorService;
    private BackendQueueProcessorFactory backendQueueProcessorFactory;
    private SearchFactoryImplementor searchFactoryImplementor;

    public BatchedQueueingProcessor(SearchFactoryImplementor searchFactoryImplementor, Properties properties) {
        String backend;
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.sync = !"async".equalsIgnoreCase(properties.getProperty("hibernate.search.worker.execution"));
        int min = Integer.parseInt(properties.getProperty("hibernate.search.worker.thread_pool.size", "1").trim());
        int queueSize = Integer.parseInt(properties.getProperty("hibernate.search.worker.buffer_queue.max", Integer.toString(Integer.MAX_VALUE)).trim());
        this.batchSize = Integer.parseInt(properties.getProperty("hibernate.search.worker.batch_size", "0").trim());
        if (!this.sync) {
            this.executorService = new ThreadPoolExecutor(min, min, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        if (StringHelper.isEmpty((String)(backend = properties.getProperty("hibernate.search.worker.backend"))) || "lucene".equalsIgnoreCase(backend)) {
            this.backendQueueProcessorFactory = new LuceneBackendQueueProcessorFactory();
        } else if ("jms".equalsIgnoreCase(backend)) {
            this.backendQueueProcessorFactory = new JMSBackendQueueProcessorFactory();
        } else {
            try {
                Class processorFactoryClass = ReflectHelper.classForName((String)backend, BatchedQueueingProcessor.class);
                this.backendQueueProcessorFactory = (BackendQueueProcessorFactory)processorFactoryClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new SearchException("Unable to find processor class: " + backend, e);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to instanciate processor class: " + backend, e);
            }
            catch (InstantiationException e) {
                throw new SearchException("Unable to instanciate processor class: " + backend, e);
            }
        }
        this.backendQueueProcessorFactory.initialize(properties, searchFactoryImplementor);
        searchFactoryImplementor.setBackendQueueProcessorFactory(this.backendQueueProcessorFactory);
    }

    public void add(Work work, WorkQueue workQueue) {
        workQueue.add(work);
        if (this.batchSize > 0 && workQueue.size() >= this.batchSize) {
            WorkQueue subQueue = workQueue.splitQueue();
            this.prepareWorks(subQueue);
            this.performWorks(subQueue);
        }
    }

    public void prepareWorks(WorkQueue workQueue) {
        List<Work> queue = workQueue.getQueue();
        int initialSize = queue.size();
        ArrayList<LuceneWork> luceneQueue = new ArrayList<LuceneWork>(initialSize);
        for (int i = 0; i < initialSize; ++i) {
            Work work = queue.get(i);
            queue.set(i, null);
            Class entityClass = work.getEntityClass() != null ? work.getEntityClass() : Hibernate.getClass((Object)work.getEntity());
            DocumentBuilder<Object> builder = this.searchFactoryImplementor.getDocumentBuilders().get(entityClass);
            if (builder == null) {
                return;
            }
            builder.addWorkToQueue(entityClass, work.getEntity(), work.getId(), work.getType(), luceneQueue, this.searchFactoryImplementor);
        }
        workQueue.setSealedQueue(luceneQueue);
    }

    public void performWorks(WorkQueue workQueue) {
        Runnable processor = this.backendQueueProcessorFactory.getProcessor(workQueue.getSealedQueue());
        if (this.sync) {
            processor.run();
        } else {
            this.executorService.execute(processor);
        }
    }

    public void cancelWorks(WorkQueue workQueue) {
        workQueue.clear();
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }
}

