/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.Worker;
import org.hibernate.search.backend.impl.TransactionalWorker;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public abstract class WorkerFactory {
    private static Properties getProperties(Configuration cfg) {
        Properties props = cfg.getProperties();
        Properties workerProperties = new Properties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("hibernate.search.worker.")) continue;
            workerProperties.setProperty(key, (String)entry.getValue());
        }
        return workerProperties;
    }

    public static Worker createWorker(Configuration cfg, SearchFactoryImplementor searchFactoryImplementor) {
        Worker worker;
        Properties props = WorkerFactory.getProperties(cfg);
        String impl = props.getProperty("hibernate.search.worker.scope");
        if (StringHelper.isEmpty((String)impl)) {
            worker = new TransactionalWorker();
        } else if ("transaction".equalsIgnoreCase(impl)) {
            worker = new TransactionalWorker();
        } else {
            try {
                Class workerClass = ReflectHelper.classForName((String)impl, WorkerFactory.class);
                worker = (Worker)workerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new SearchException("Unable to find worker class: " + impl, e);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to instanciate worker class: " + impl, e);
            }
            catch (InstantiationException e) {
                throw new SearchException("Unable to instanciate worker class: " + impl, e);
            }
        }
        worker.initialize(props, searchFactoryImplementor);
        return worker;
    }
}

