/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spi;

import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.LogErrorHandler;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ErrorHandlerFactory {
    private ErrorHandlerFactory() {
    }

    public static ErrorHandler getDefault() {
        return new LogErrorHandler();
    }

    public static ErrorHandler createErrorHandler(SearchConfiguration searchConfiguration) {
        Object configuredErrorHandler = searchConfiguration.getProperties().get("hibernate.search.error_handler");
        if (configuredErrorHandler == null) {
            return ErrorHandlerFactory.getDefault();
        }
        if (configuredErrorHandler instanceof String) {
            return ErrorHandlerFactory.createErrorHandlerFromString((String)configuredErrorHandler, searchConfiguration.getClassLoaderService());
        }
        if (configuredErrorHandler instanceof ErrorHandler) {
            return (ErrorHandler)configuredErrorHandler;
        }
        throw LoggerFactory.make().unsupportedErrorHandlerConfigurationValueType(configuredErrorHandler.getClass());
    }

    private static ErrorHandler createErrorHandlerFromString(String errorHandlerClassName, ClassLoaderService classLoaderService) {
        if (StringHelper.isEmpty(errorHandlerClassName) || "log".equals(errorHandlerClassName.trim())) {
            return ErrorHandlerFactory.getDefault();
        }
        Class errorHandlerClass = classLoaderService.classForName(errorHandlerClassName);
        return ClassLoaderHelper.instanceFromClass(ErrorHandler.class, errorHandlerClass, "Error Handler");
    }
}

