/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.Version;
import org.hibernate.search.analyzer.definition.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.backend.impl.lucene.analysis.HibernateSearchNormalizerWrapper;
import org.hibernate.search.cfg.spi.ParameterAnnotationsReader;
import org.hibernate.search.engine.impl.TokenizerChain;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.HibernateSearchResourceLoader;

final class LuceneAnalyzerBuilder {
    private static final String LUCENE_VERSION_PARAM = "luceneMatchVersion";
    private static final Parameter[] EMPTY_PARAMETERS = new Parameter[0];
    private final Version luceneMatchVersion;
    private final ResourceLoader resourceLoader;
    private final LuceneAnalysisDefinitionRegistry definitionRegistry;

    public LuceneAnalyzerBuilder(Version luceneMatchVersion, ServiceManager serviceManager, LuceneAnalysisDefinitionRegistry definitionRegistry) {
        this.luceneMatchVersion = luceneMatchVersion;
        this.resourceLoader = new HibernateSearchResourceLoader(serviceManager);
        this.definitionRegistry = definitionRegistry;
    }

    public Analyzer buildAnalyzer(String name) {
        AnalyzerDef analyzerDefinition = this.definitionRegistry.getAnalyzerDefinition(name);
        if (analyzerDefinition == null) {
            throw new SearchException("Lucene analyzer found with an unknown definition: " + name);
        }
        try {
            return this.buildAnalyzer(analyzerDefinition);
        }
        catch (IOException e) {
            throw new SearchException("Could not initialize Analyzer definition " + analyzerDefinition, e);
        }
    }

    public Analyzer buildNormalizer(String name) {
        NormalizerDef definition = this.definitionRegistry.getNormalizerDefinition(name);
        if (definition == null) {
            throw new SearchException("Lucene normalizer found with an unknown definition: " + name);
        }
        try {
            return this.buildNormalizer(definition);
        }
        catch (IOException e) {
            throw new SearchException("Could not initialize normalizer definition " + definition, e);
        }
    }

    private Analyzer buildAnalyzer(AnalyzerDef analyzerDef) throws IOException {
        TokenizerDef tokenizer = analyzerDef.tokenizer();
        TokenizerFactory tokenizerFactory = this.buildAnalysisComponent(TokenizerFactory.class, tokenizer.factory(), tokenizer.params());
        return this.buildAnalyzer(tokenizerFactory, analyzerDef.charFilters(), analyzerDef.filters());
    }

    private Analyzer buildNormalizer(NormalizerDef normalizerDef) throws IOException {
        TokenizerFactory tokenizerFactory = (TokenizerFactory)this.buildAnalysisComponent(TokenizerFactory.class, KeywordTokenizerFactory.class, EMPTY_PARAMETERS);
        Analyzer normalizer = this.buildAnalyzer(tokenizerFactory, normalizerDef.charFilters(), normalizerDef.filters());
        return new HibernateSearchNormalizerWrapper(normalizer, normalizerDef.name());
    }

    private Analyzer buildAnalyzer(TokenizerFactory tokenizerFactory, CharFilterDef[] charFilterDefs, TokenFilterDef[] filterDefs) throws IOException {
        int tokenFiltersLength = filterDefs.length;
        TokenFilterFactory[] filters = new TokenFilterFactory[tokenFiltersLength];
        for (int index = 0; index < tokenFiltersLength; ++index) {
            TokenFilterDef filterDef = filterDefs[index];
            filters[index] = this.buildAnalysisComponent(TokenFilterFactory.class, filterDef.factory(), filterDef.params());
        }
        int charFiltersLength = charFilterDefs.length;
        CharFilterFactory[] charFilters = new CharFilterFactory[charFiltersLength];
        for (int index = 0; index < charFiltersLength; ++index) {
            CharFilterDef charFilterDef = charFilterDefs[index];
            charFilters[index] = this.buildAnalysisComponent(CharFilterFactory.class, charFilterDef.factory(), charFilterDef.params());
        }
        return new TokenizerChain(charFilters, tokenizerFactory, filters);
    }

    private <T> T buildAnalysisComponent(Class<T> expectedFactoryClass, Class<? extends T> factoryClass, Parameter[] parameters) throws IOException {
        Map<String, String> tokenMapsOfParameters = LuceneAnalyzerBuilder.getMapOfParameters(parameters, this.luceneMatchVersion);
        T tokenizerFactory = ClassLoaderHelper.instanceFromClass(expectedFactoryClass, factoryClass, "Tokenizer factory", tokenMapsOfParameters);
        this.injectResourceLoader(tokenizerFactory, tokenMapsOfParameters);
        return tokenizerFactory;
    }

    private void injectResourceLoader(Object processor, Map<String, String> mapOfParameters) throws IOException {
        if (processor instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)processor).inform(this.resourceLoader);
        }
    }

    private static Map<String, String> getMapOfParameters(Parameter[] params, Version luceneMatchVersion) {
        Map<String, String> mapOfParams = ParameterAnnotationsReader.toNewMutableMap(params);
        mapOfParams.put(LUCENE_VERSION_PARAM, luceneMatchVersion.toString());
        return mapOfParams;
    }
}

