/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.collections.IntToDoubleMap;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;

public class DistanceCollector
extends Collector {
    private Collector delegate;
    private boolean acceptsDocsOutOfOrder;
    private Point center;
    private String latitudeField;
    private String longitudeField;
    private int docBase = 0;
    private IntToDoubleMap distances;
    private IntToDoubleMap latitudeValues;
    private IntToDoubleMap longitudeValues;

    public DistanceCollector(Collector delegate, Point center, int hitsCount, String fieldname) {
        this.delegate = delegate;
        this.acceptsDocsOutOfOrder = delegate.acceptsDocsOutOfOrder();
        this.center = center;
        this.distances = new IntToDoubleMap(hitsCount);
        this.latitudeValues = new IntToDoubleMap(hitsCount);
        this.longitudeValues = new IntToDoubleMap(hitsCount);
        this.latitudeField = SpatialHelper.formatLatitude(fieldname);
        this.longitudeField = SpatialHelper.formatLongitude(fieldname);
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }

    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
        int absolute = this.docBase + doc;
        this.distances.put(absolute, this.center.getDistanceTo(this.latitudeValues.get(absolute), this.longitudeValues.get(absolute)));
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.delegate.setNextReader(reader, docBase);
        double[] unbasedLatitudeValues = FieldCache.DEFAULT.getDoubles(reader, this.latitudeField);
        double[] unbasedLongitudeValues = FieldCache.DEFAULT.getDoubles(reader, this.longitudeField);
        this.docBase = docBase;
        for (int i = 0; i < unbasedLatitudeValues.length; ++i) {
            this.latitudeValues.put(this.docBase + i, unbasedLatitudeValues[i]);
            this.longitudeValues.put(this.docBase + i, unbasedLongitudeValues[i]);
        }
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.acceptsDocsOutOfOrder;
    }

    public double getDistance(int index) {
        return this.distances.get(index);
    }
}

