/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;

public abstract class SolrAnalyzer
extends Analyzer {
    int posIncGap = 0;

    public void setPositionIncrementGap(int gap) {
        this.posIncGap = gap;
    }

    public int getPositionIncrementGap(String fieldName) {
        return this.posIncGap;
    }

    public Reader charStream(Reader reader) {
        return reader;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return this.getStream(fieldName, reader).getTokenStream();
    }

    public abstract TokenStreamInfo getStream(String var1, Reader var2);

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        TokenStreamInfo tsi = (TokenStreamInfo)this.getPreviousTokenStream();
        if (tsi != null) {
            tsi.getTokenizer().reset(this.charStream(reader));
            return tsi.getTokenStream();
        }
        tsi = this.getStream(fieldName, reader);
        this.setPreviousTokenStream(tsi);
        return tsi.getTokenStream();
    }

    public static class TokenStreamInfo {
        private final Tokenizer tokenizer;
        private final TokenStream tokenStream;

        public TokenStreamInfo(Tokenizer tokenizer, TokenStream tokenStream) {
            this.tokenizer = tokenizer;
            this.tokenStream = tokenStream;
        }

        public Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        public TokenStream getTokenStream() {
            return this.tokenStream;
        }
    }
}

