/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.util;

public class StringUtil {
    private static final String NAME_SEPARATOR = ".";
    private static final String PROPERTY_PREFIX_GET = "get";
    private static final String PROPERTY_PREFIX_IS = "is";
    private static final String PROPERTY_PREFIX_HAS = "has";

    private StringUtil() {
    }

    public static String determineFullyQualifiedClassName(String defaultPackage, String name) {
        if (StringUtil.isFullyQualified(name)) {
            return name;
        }
        return defaultPackage + NAME_SEPARATOR + name;
    }

    public static boolean isFullyQualified(String name) {
        return name.contains(NAME_SEPARATOR);
    }

    public static String packageNameFromFqcn(String fqcn) {
        return fqcn.substring(0, fqcn.lastIndexOf(NAME_SEPARATOR));
    }

    public static String classNameFromFqcn(String fqcn) {
        return fqcn.substring(fqcn.lastIndexOf(NAME_SEPARATOR) + 1);
    }

    public static boolean isPropertyName(String name) {
        return name.startsWith(PROPERTY_PREFIX_GET) || name.startsWith(PROPERTY_PREFIX_IS) || name.startsWith(PROPERTY_PREFIX_HAS);
    }

    public static String getPropertyName(String name) {
        if (!StringUtil.isPropertyName(name)) {
            return null;
        }
        if (name.startsWith(PROPERTY_PREFIX_GET)) {
            name = name.replaceFirst(PROPERTY_PREFIX_GET, "");
        } else if (name.startsWith(PROPERTY_PREFIX_IS)) {
            name = name.replaceFirst(PROPERTY_PREFIX_IS, "");
        } else if (name.startsWith(PROPERTY_PREFIX_HAS)) {
            name = name.replaceFirst(PROPERTY_PREFIX_HAS, "");
        }
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }
}

