/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;
import org.hibernate.jpamodelgen.model.MetaAttribute;

public class AnnotationEmbeddable
extends AnnotationMetaEntity {
    private boolean initialized;

    public AnnotationEmbeddable(TypeElement element, Context context) {
        super(element, context, true);
    }

    @Override
    public List<MetaAttribute> getMembers() {
        if (!this.initialized) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Entity " + this.getQualifiedName() + " was lazily initialised.");
            this.init();
            this.initialized = true;
        }
        return super.getMembers();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AnnotationEmbeddable");
        sb.append("{element=").append(this.element);
        sb.append(", members=");
        if (this.initialized) {
            sb.append(this.members);
        } else {
            sb.append("[un-initalized]");
        }
        sb.append('}');
        return sb.toString();
    }
}

