/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.jpa;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PersistenceException;
import org.hibernate.jpa.event.spi.jpa.ListenerFactory;

public class StandardListenerFactory
implements ListenerFactory {
    private Map listenerInstances = new ConcurrentHashMap();

    @Override
    public <T> T buildListener(Class<T> listenerClass) {
        Object listenerInstance = this.listenerInstances.get(listenerClass);
        if (listenerInstance == null) {
            try {
                listenerInstance = listenerClass.newInstance();
            }
            catch (Exception e) {
                throw new PersistenceException("Unable to create instance of " + listenerClass.getName() + " as a JPA callback listener", (Throwable)e);
            }
            this.listenerInstances.put(listenerClass, listenerInstance);
        }
        return (T)listenerInstance;
    }

    @Override
    public void release() {
        this.listenerInstances.clear();
    }
}

