/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockScope;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.SynchronizationType;
import javax.persistence.TransactionRequiredException;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.PessimisticLockException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.dialect.lock.LockingStrategyException;
import org.hibernate.dialect.lock.OptimisticEntityLockException;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.spi.JoinStatus;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.engine.transaction.synchronization.spi.AfterCompletionAction;
import org.hibernate.engine.transaction.synchronization.spi.ExceptionMapper;
import org.hibernate.engine.transaction.synchronization.spi.ManagedFlushChecker;
import org.hibernate.engine.transaction.synchronization.spi.SynchronizationCallbackCoordinator;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.jpa.criteria.ValueHandlerFactory;
import org.hibernate.jpa.criteria.compile.CompilableCriteria;
import org.hibernate.jpa.criteria.compile.CriteriaCompiler;
import org.hibernate.jpa.criteria.expression.CompoundSelectionImpl;
import org.hibernate.jpa.internal.EntityManagerFactoryImpl;
import org.hibernate.jpa.internal.EntityManagerMessageLogger;
import org.hibernate.jpa.internal.QueryImpl;
import org.hibernate.jpa.internal.StoredProcedureQueryImpl;
import org.hibernate.jpa.internal.TransactionImpl;
import org.hibernate.jpa.internal.util.CacheModeHelper;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.jpa.spi.HibernateEntityManagerImplementor;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.transform.BasicTransformerAdapter;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public abstract class AbstractEntityManagerImpl
implements HibernateEntityManagerImplementor,
Serializable {
    private static final long serialVersionUID = 78818181L;
    private static final EntityManagerMessageLogger LOG = (EntityManagerMessageLogger)Logger.getMessageLogger(EntityManagerMessageLogger.class, (String)AbstractEntityManagerImpl.class.getName());
    private static final List<String> entityManagerSpecificProperties = new ArrayList<String>();
    private EntityManagerFactoryImpl entityManagerFactory;
    protected transient TransactionImpl tx = new TransactionImpl(this);
    protected PersistenceContextType persistenceContextType;
    private SynchronizationType synchronizationType;
    private PersistenceUnitTransactionType transactionType;
    private Map<String, Object> properties;
    private LockOptions lockOptions;
    private CriteriaCompiler criteriaCompiler;

    protected AbstractEntityManagerImpl(EntityManagerFactoryImpl entityManagerFactory, PersistenceContextType type, SynchronizationType synchronizationType, PersistenceUnitTransactionType transactionType, Map properties) {
        this.entityManagerFactory = entityManagerFactory;
        this.persistenceContextType = type;
        this.synchronizationType = synchronizationType;
        this.transactionType = transactionType;
        this.lockOptions = new LockOptions();
        this.properties = new HashMap<String, Object>();
        for (String key : entityManagerSpecificProperties) {
            if (entityManagerFactory.getProperties().containsKey(key)) {
                this.properties.put(key, entityManagerFactory.getProperties().get(key));
            }
            if (properties == null || !properties.containsKey(key)) continue;
            this.properties.put(key, properties.get(key));
        }
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    protected void postInit() {
        if (this.transactionType == PersistenceUnitTransactionType.JTA && this.synchronizationType == SynchronizationType.SYNCHRONIZED) {
            this.joinTransaction(false);
        }
        this.setDefaultProperties();
        this.applyProperties();
    }

    private void applyProperties() {
        this.getSession().setFlushMode(ConfigurationHelper.getFlushMode(this.properties.get("org.hibernate.flushMode")));
        this.setLockOptions(this.properties, this.lockOptions);
        this.getSession().setCacheMode(CacheModeHelper.interpretCacheMode(this.currentCacheStoreMode(), this.currentCacheRetrieveMode()));
    }

    private javax.persistence.Query applyProperties(javax.persistence.Query query) {
        Object lockTimeout;
        Object queryTimeout;
        if (this.lockOptions.getLockMode() != LockMode.NONE) {
            query.setLockMode(this.getLockMode(this.lockOptions.getLockMode()));
        }
        if ((queryTimeout = this.getProperties().get("javax.persistence.query.timeout")) != null) {
            query.setHint("javax.persistence.query.timeout", queryTimeout);
        }
        if ((lockTimeout = this.getProperties().get("javax.persistence.lock.timeout")) != null) {
            query.setHint("javax.persistence.lock.timeout", lockTimeout);
        }
        return query;
    }

    private CacheRetrieveMode currentCacheRetrieveMode() {
        return this.determineCacheRetrieveMode(this.properties);
    }

    private CacheRetrieveMode determineCacheRetrieveMode(Map<String, Object> settings) {
        return (CacheRetrieveMode)settings.get("javax.persistence.cache.retrieveMode");
    }

    private CacheStoreMode currentCacheStoreMode() {
        return this.determineCacheStoreMode(this.properties);
    }

    private CacheStoreMode determineCacheStoreMode(Map<String, Object> settings) {
        return (CacheStoreMode)this.properties.get("javax.persistence.cache.storeMode");
    }

    private void setLockOptions(Map<String, Object> props, LockOptions options) {
        Object lockScope = props.get("javax.persistence.lock.scope");
        if (lockScope instanceof String && PessimisticLockScope.valueOf((String)((String)lockScope)) == PessimisticLockScope.EXTENDED) {
            options.setScope(true);
        } else if (lockScope instanceof PessimisticLockScope) {
            boolean extended = PessimisticLockScope.EXTENDED.equals(lockScope);
            options.setScope(extended);
        } else if (lockScope != null) {
            throw new PersistenceException("Unable to parse javax.persistence.lock.scope: " + lockScope);
        }
        Object lockTimeout = props.get("javax.persistence.lock.timeout");
        int timeout = 0;
        boolean timeoutSet = false;
        if (lockTimeout instanceof String) {
            timeout = Integer.parseInt((String)lockTimeout);
            timeoutSet = true;
        } else if (lockTimeout instanceof Number) {
            timeout = ((Number)lockTimeout).intValue();
            timeoutSet = true;
        } else if (lockTimeout != null) {
            throw new PersistenceException("Unable to parse javax.persistence.lock.timeout: " + lockTimeout);
        }
        if (timeoutSet) {
            if (timeout == -2) {
                options.setTimeOut(-2);
            } else if (timeout < 0) {
                options.setTimeOut(-1);
            } else if (timeout == 0) {
                options.setTimeOut(0);
            } else {
                options.setTimeOut(timeout);
            }
        }
    }

    private void setDefaultProperties() {
        if (this.properties.get("org.hibernate.flushMode") == null) {
            this.properties.put("org.hibernate.flushMode", this.getSession().getFlushMode().toString());
        }
        if (this.properties.get("javax.persistence.lock.scope") == null) {
            this.properties.put("javax.persistence.lock.scope", PessimisticLockScope.EXTENDED.name());
        }
        if (this.properties.get("javax.persistence.lock.timeout") == null) {
            this.properties.put("javax.persistence.lock.timeout", -1);
        }
        if (this.properties.get("javax.persistence.cache.retrieveMode") == null) {
            this.properties.put("javax.persistence.cache.retrieveMode", CacheModeHelper.DEFAULT_RETRIEVE_MODE);
        }
        if (this.properties.get("javax.persistence.cache.storeMode") == null) {
            this.properties.put("javax.persistence.cache.storeMode", CacheModeHelper.DEFAULT_STORE_MODE);
        }
    }

    public javax.persistence.Query createQuery(String jpaqlString) {
        this.checkOpen();
        try {
            return this.applyProperties(new QueryImpl(this.internalGetSession().createQuery(jpaqlString), this));
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    protected abstract void checkOpen();

    public <T> TypedQuery<T> createQuery(String jpaqlString, Class<T> resultClass) {
        this.checkOpen();
        try {
            Query hqlQuery = this.internalGetSession().createQuery(jpaqlString);
            this.resultClassChecking(resultClass, hqlQuery);
            return new QueryImpl(hqlQuery, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    protected void resultClassChecking(Class resultClass, Query hqlQuery) {
        SessionImplementor session = this.unwrap(SessionImplementor.class);
        HQLQueryPlan queryPlan = session.getFactory().getQueryPlanCache().getHQLQueryPlan(hqlQuery.getQueryString(), false, session.getLoadQueryInfluencers().getEnabledFilters());
        if (queryPlan.getTranslators()[0].isManipulationStatement()) {
            throw new IllegalArgumentException("Update/delete queries cannot be typed");
        }
        if (!Object[].class.equals((Object)resultClass)) {
            if (Tuple.class.equals((Object)resultClass)) {
                TupleBuilderTransformer tupleTransformer = new TupleBuilderTransformer(hqlQuery);
                hqlQuery.setResultTransformer((ResultTransformer)tupleTransformer);
            } else {
                Class dynamicInstantiationClass = queryPlan.getDynamicInstantiationResultType();
                if (dynamicInstantiationClass != null) {
                    if (!resultClass.isAssignableFrom(dynamicInstantiationClass)) {
                        throw new IllegalArgumentException("Mismatch in requested result type [" + resultClass.getName() + "] and actual result type [" + dynamicInstantiationClass.getName() + "]");
                    }
                } else if (hqlQuery.getReturnTypes().length == 1) {
                    if (!resultClass.isAssignableFrom(hqlQuery.getReturnTypes()[0].getReturnedClass())) {
                        throw new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + hqlQuery.getReturnTypes()[0].getReturnedClass() + "]");
                    }
                } else {
                    throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return using requested result type [" + resultClass.getName() + "]");
                }
            }
        }
    }

    @Override
    public <T> QueryImpl<T> createQuery(String jpaqlString, Class<T> resultClass, Selection selection, HibernateEntityManagerImplementor.Options options) {
        try {
            List<Selection<?>> tupleElements;
            Query hqlQuery = this.internalGetSession().createQuery(jpaqlString);
            if (options.getValueHandlers() == null && options.getResultMetadataValidator() != null) {
                options.getResultMetadataValidator().validate(hqlQuery.getReturnTypes());
            }
            List<Selection<?>> list = tupleElements = Tuple.class.equals(resultClass) ? ((CompoundSelectionImpl)selection).getCompoundSelectionItems() : null;
            if (options.getValueHandlers() != null || tupleElements != null) {
                hqlQuery.setResultTransformer((ResultTransformer)new CriteriaQueryTransformer(options.getValueHandlers(), tupleElements));
            }
            return new QueryImpl(hqlQuery, this, options.getNamedParameterExplicitTypes());
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    protected CriteriaCompiler criteriaCompiler() {
        if (this.criteriaCompiler == null) {
            this.criteriaCompiler = new CriteriaCompiler(this);
        }
        return this.criteriaCompiler;
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        this.checkOpen();
        return (TypedQuery)this.criteriaCompiler().compile((CompilableCriteria)criteriaQuery);
    }

    public javax.persistence.Query createQuery(CriteriaUpdate criteriaUpdate) {
        this.checkOpen();
        return this.criteriaCompiler().compile((CompilableCriteria)criteriaUpdate);
    }

    public javax.persistence.Query createQuery(CriteriaDelete criteriaDelete) {
        this.checkOpen();
        return this.criteriaCompiler().compile((CompilableCriteria)criteriaDelete);
    }

    public javax.persistence.Query createNamedQuery(String name) {
        this.checkOpen();
        try {
            Query namedQuery = this.internalGetSession().getNamedQuery(name);
            try {
                return new QueryImpl(namedQuery, this);
            }
            catch (HibernateException he) {
                throw this.convert(he);
            }
        }
        catch (MappingException e) {
            throw new IllegalArgumentException("Named query not found: " + name);
        }
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        this.checkOpen();
        try {
            Query namedQuery = this.internalGetSession().getNamedQuery(name);
            SessionFactoryImpl factoryImplementor = this.entityManagerFactory.getSessionFactory();
            NamedSQLQueryDefinition queryDefinition = factoryImplementor.getNamedSQLQuery(name);
            try {
                if (queryDefinition != null) {
                    NativeSQLQueryReturn[] queryReturns;
                    if (queryDefinition.getQueryReturns() != null) {
                        queryReturns = queryDefinition.getQueryReturns();
                    } else if (queryDefinition.getResultSetRef() != null) {
                        ResultSetMappingDefinition rsMapping = factoryImplementor.getResultSetMapping(queryDefinition.getResultSetRef());
                        queryReturns = rsMapping.getQueryReturns();
                    } else {
                        throw new AssertionFailure("Unsupported named query model. Please report the bug in Hibernate EntityManager");
                    }
                    if (queryReturns.length > 1) {
                        throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return");
                    }
                    NativeSQLQueryReturn nativeSQLQueryReturn = queryReturns[0];
                    if (nativeSQLQueryReturn instanceof NativeSQLQueryRootReturn) {
                        Class actualReturnedClass;
                        String entityClassName = ((NativeSQLQueryRootReturn)nativeSQLQueryReturn).getReturnEntityName();
                        try {
                            actualReturnedClass = ReflectHelper.classForName((String)entityClassName, AbstractEntityManagerImpl.class);
                        }
                        catch (ClassNotFoundException e) {
                            throw new AssertionFailure("Unable to instantiate class declared on named native query: " + name + " " + entityClassName);
                        }
                        if (!resultClass.isAssignableFrom(actualReturnedClass)) {
                            throw this.buildIncompatibleException(resultClass, actualReturnedClass);
                        }
                    }
                } else {
                    this.resultClassChecking(resultClass, namedQuery);
                }
                return new QueryImpl(namedQuery, this);
            }
            catch (HibernateException he) {
                throw this.convert(he);
            }
        }
        catch (MappingException e) {
            throw new IllegalArgumentException("Named query not found: " + name);
        }
    }

    private IllegalArgumentException buildIncompatibleException(Class<?> resultClass, Class<?> actualResultClass) {
        return new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + actualResultClass + "]");
    }

    public javax.persistence.Query createNativeQuery(String sqlString) {
        this.checkOpen();
        try {
            SQLQuery q = this.internalGetSession().createSQLQuery(sqlString);
            return new QueryImpl((Query)q, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString, Class resultClass) {
        this.checkOpen();
        try {
            SQLQuery q = this.internalGetSession().createSQLQuery(sqlString);
            q.addEntity("alias1", resultClass.getName(), LockMode.READ);
            return new QueryImpl((Query)q, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString, String resultSetMapping) {
        this.checkOpen();
        try {
            SQLQuery q = this.internalGetSession().createSQLQuery(sqlString);
            q.setResultSetMapping(resultSetMapping);
            return new QueryImpl((Query)q, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        this.checkOpen();
        throw new NotYetImplementedException();
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        this.checkOpen();
        try {
            ProcedureCall procedureCall = this.internalGetSession().createStoredProcedureCall(procedureName);
            return new StoredProcedureQueryImpl(procedureCall, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        this.checkOpen();
        try {
            ProcedureCall procedureCall = this.internalGetSession().createStoredProcedureCall(procedureName, resultClasses);
            return new StoredProcedureQueryImpl(procedureCall, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        this.checkOpen();
        throw new NotYetImplementedException();
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        this.checkOpen();
        try {
            return (T)this.internalGetSession().load(entityClass, (Serializable)primaryKey);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public <A> A find(Class<A> entityClass, Object primaryKey) {
        this.checkOpen();
        return this.find(entityClass, primaryKey, null, null);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        this.checkOpen();
        return this.find(entityClass, primaryKey, null, properties);
    }

    public <A> A find(Class<A> entityClass, Object primaryKey, LockModeType lockModeType) {
        this.checkOpen();
        return this.find(entityClass, primaryKey, lockModeType, null);
    }

    public <A> A find(Class<A> entityClass, Object primaryKey, LockModeType lockModeType, Map<String, Object> properties) {
        this.checkOpen();
        Session session = this.internalGetSession();
        CacheMode previousCacheMode = session.getCacheMode();
        CacheMode cacheMode = this.determineAppropriateLocalCacheMode(properties);
        LockOptions lockOptions = null;
        try {
            session.setCacheMode(cacheMode);
            if (lockModeType != null) {
                lockOptions = this.getLockRequest(lockModeType, properties);
                Object object = session.get(entityClass, (Serializable)primaryKey, lockOptions);
                return (A)object;
            }
            Object object = session.get(entityClass, (Serializable)primaryKey);
            return (A)object;
        }
        catch (EntityNotFoundException ignored) {
            if (LOG.isDebugEnabled()) {
                String entityName = entityClass != null ? entityClass.getName() : null;
                String identifierValue = primaryKey != null ? primaryKey.toString() : null;
                LOG.ignoringEntityNotFound(entityName, identifierValue);
            }
            A a = null;
            return a;
        }
        catch (ObjectDeletedException e) {
            A a = null;
            return a;
        }
        catch (ObjectNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he, lockOptions);
        }
        finally {
            session.setCacheMode(previousCacheMode);
        }
    }

    public CacheMode determineAppropriateLocalCacheMode(Map<String, Object> localProperties) {
        CacheRetrieveMode retrieveMode = null;
        CacheStoreMode storeMode = null;
        if (localProperties != null) {
            retrieveMode = this.determineCacheRetrieveMode(localProperties);
            storeMode = this.determineCacheStoreMode(localProperties);
        }
        if (retrieveMode == null) {
            retrieveMode = this.determineCacheRetrieveMode(this.properties);
        }
        if (storeMode == null) {
            storeMode = this.determineCacheStoreMode(this.properties);
        }
        return CacheModeHelper.interpretCacheMode(storeMode, retrieveMode);
    }

    private void checkTransactionNeeded() {
        if (this.persistenceContextType == PersistenceContextType.TRANSACTION && !this.isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress for a TRANSACTION type persistence context");
        }
    }

    public void persist(Object entity) {
        this.checkOpen();
        this.checkTransactionNeeded();
        try {
            this.internalGetSession().persist(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    public <A> A merge(A entity) {
        this.checkOpen();
        this.checkTransactionNeeded();
        try {
            return (A)this.internalGetSession().merge(entity);
        }
        catch (ObjectDeletedException sse) {
            throw new IllegalArgumentException(sse);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    public void remove(Object entity) {
        this.checkOpen();
        this.checkTransactionNeeded();
        try {
            this.internalGetSession().delete(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    public void refresh(Object entity) {
        this.refresh(entity, null, null);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity, null, properties);
    }

    public void refresh(Object entity, LockModeType lockModeType) {
        this.refresh(entity, lockModeType, null);
    }

    public void refresh(Object entity, LockModeType lockModeType, Map<String, Object> properties) {
        this.checkOpen();
        this.checkTransactionNeeded();
        Session session = this.internalGetSession();
        CacheMode previousCacheMode = session.getCacheMode();
        CacheMode localCacheMode = this.determineAppropriateLocalCacheMode(properties);
        LockOptions lockOptions = null;
        try {
            session.setCacheMode(localCacheMode);
            if (!session.contains(entity)) {
                throw new IllegalArgumentException("Entity not managed");
            }
            if (lockModeType != null) {
                lockOptions = this.getLockRequest(lockModeType, properties);
                session.refresh(entity, lockOptions);
            } else {
                session.refresh(entity);
            }
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he, lockOptions);
        }
        finally {
            session.setCacheMode(previousCacheMode);
        }
    }

    public boolean contains(Object entity) {
        this.checkOpen();
        try {
            if (entity != null && !(entity instanceof HibernateProxy) && this.internalGetSession().getSessionFactory().getClassMetadata(entity.getClass()) == null) {
                throw new IllegalArgumentException("Not an entity:" + entity.getClass());
            }
            return this.internalGetSession().contains(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public LockModeType getLockMode(Object entity) {
        this.checkOpen();
        if (!this.contains(entity)) {
            throw new IllegalArgumentException("entity not in the persistence context");
        }
        return AbstractEntityManagerImpl.getLockModeType(this.internalGetSession().getCurrentLockMode(entity));
    }

    public void setProperty(String s, Object o) {
        this.checkOpen();
        if (entityManagerSpecificProperties.contains(s)) {
            this.properties.put(s, o);
            this.applyProperties();
        } else {
            LOG.debugf("Trying to set a property which is not supported on entity manager level", new Object[0]);
        }
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void flush() {
        this.checkOpen();
        if (!this.isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress");
        }
        try {
            this.internalGetSession().flush();
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public abstract Session getSession();

    @Deprecated
    protected abstract Session getRawSession();

    protected abstract Session internalGetSession();

    public EntityTransaction getTransaction() {
        if (this.transactionType == PersistenceUnitTransactionType.JTA) {
            throw new IllegalStateException("A JTA EntityManager cannot use getTransaction()");
        }
        return this.tx;
    }

    public EntityManagerFactoryImpl getEntityManagerFactory() {
        this.checkOpen();
        return this.internalGetEntityManagerFactory();
    }

    protected EntityManagerFactoryImpl internalGetEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    @Override
    public HibernateEntityManagerFactory getFactory() {
        return this.entityManagerFactory;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        this.checkOpen();
        return this.getEntityManagerFactory().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        this.checkOpen();
        return this.getEntityManagerFactory().getMetamodel();
    }

    public void setFlushMode(FlushModeType flushModeType) {
        this.checkOpen();
        if (flushModeType == FlushModeType.AUTO) {
            this.internalGetSession().setFlushMode(FlushMode.AUTO);
        } else if (flushModeType == FlushModeType.COMMIT) {
            this.internalGetSession().setFlushMode(FlushMode.COMMIT);
        } else {
            throw new AssertionFailure("Unknown FlushModeType: " + flushModeType);
        }
    }

    public void clear() {
        this.checkOpen();
        try {
            this.internalGetSession().clear();
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public void detach(Object entity) {
        this.checkOpen();
        try {
            this.internalGetSession().evict(entity);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public FlushModeType getFlushMode() {
        this.checkOpen();
        FlushMode mode = this.internalGetSession().getFlushMode();
        if (mode == FlushMode.AUTO) {
            return FlushModeType.AUTO;
        }
        if (mode == FlushMode.COMMIT) {
            return FlushModeType.COMMIT;
        }
        return null;
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.lock(entity, lockMode, null);
    }

    public void lock(Object entity, LockModeType lockModeType, Map<String, Object> properties) {
        this.checkOpen();
        LockOptions lockOptions = null;
        if (!this.isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress");
        }
        try {
            if (!this.contains(entity)) {
                throw new IllegalArgumentException("entity not in the persistence context");
            }
            lockOptions = this.getLockRequest(lockModeType, properties);
            this.internalGetSession().buildLockRequest(lockOptions).lock(entity);
        }
        catch (HibernateException he) {
            throw this.convert(he, lockOptions);
        }
    }

    @Override
    public LockOptions getLockRequest(LockModeType lockModeType, Map<String, Object> properties) {
        LockOptions lockOptions = new LockOptions();
        LockOptions.copy((LockOptions)this.lockOptions, (LockOptions)lockOptions);
        lockOptions.setLockMode(AbstractEntityManagerImpl.getLockMode(lockModeType));
        if (properties != null) {
            this.setLockOptions(properties, lockOptions);
        }
        return lockOptions;
    }

    private static LockModeType getLockModeType(LockMode lockMode) {
        return LockModeTypeHelper.getLockModeType(lockMode);
    }

    private static LockMode getLockMode(LockModeType lockMode) {
        return LockModeTypeHelper.getLockMode(lockMode);
    }

    @Override
    public boolean isTransactionInProgress() {
        return ((SessionImplementor)this.internalGetSession()).isTransactionInProgress();
    }

    private SessionFactoryImplementor sfi() {
        return (SessionFactoryImplementor)this.internalGetSession().getSessionFactory();
    }

    public <T> T unwrap(Class<T> clazz) {
        this.checkOpen();
        if (Session.class.isAssignableFrom(clazz)) {
            return (T)this.internalGetSession();
        }
        if (SessionImplementor.class.isAssignableFrom(clazz)) {
            return (T)this.internalGetSession();
        }
        if (EntityManager.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        throw new PersistenceException("Hibernate cannot unwrap " + clazz);
    }

    protected void markAsRollback() {
        LOG.debugf("Mark transaction for rollback", new Object[0]);
        if (this.tx.isActive()) {
            this.tx.setRollbackOnly();
        } else if (PersistenceUnitTransactionType.JTA == this.transactionType) {
            TransactionManager transactionManager = ((JtaPlatform)this.sfi().getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
            if (transactionManager == null) {
                throw new PersistenceException("Using a JTA persistence context wo setting hibernate.transaction.manager_lookup_class");
            }
            try {
                if (transactionManager.getStatus() != 6) {
                    transactionManager.setRollbackOnly();
                }
            }
            catch (SystemException e) {
                throw new PersistenceException("Unable to set the JTA transaction as RollbackOnly", (Throwable)e);
            }
        }
    }

    public boolean isJoinedToTransaction() {
        this.checkOpen();
        SessionImplementor session = (SessionImplementor)this.internalGetSession();
        TransactionCoordinator transactionCoordinator = session.getTransactionCoordinator();
        TransactionImplementor transaction = transactionCoordinator.getTransaction();
        return this.isOpen() && transaction.getJoinStatus() == JoinStatus.JOINED;
    }

    public void joinTransaction() {
        this.checkOpen();
        this.joinTransaction(true);
    }

    private void joinTransaction(boolean explicitRequest) {
        if (this.transactionType != PersistenceUnitTransactionType.JTA) {
            if (explicitRequest) {
                LOG.callingJoinTransactionOnNonJtaEntityManager();
            }
            return;
        }
        SessionImplementor session = (SessionImplementor)this.internalGetSession();
        TransactionCoordinator transactionCoordinator = session.getTransactionCoordinator();
        TransactionImplementor transaction = transactionCoordinator.getTransaction();
        transaction.markForJoin();
        transactionCoordinator.pulse();
        LOG.debug("Looking for a JTA transaction to join");
        if (!transactionCoordinator.isTransactionJoinable() && explicitRequest) {
            LOG.unableToJoinTransaction("hibernate.transaction.factory_class");
        }
        try {
            if (transaction.getJoinStatus() == JoinStatus.JOINED) {
                LOG.debug("Transaction already joined");
                return;
            }
            transaction.join();
            if (transaction.getJoinStatus() == JoinStatus.NOT_JOINED) {
                if (explicitRequest) {
                    throw new TransactionRequiredException("No active JTA transaction on joinTransaction call");
                }
                LOG.debug("Unable to join JTA transaction");
                return;
            }
            if (transaction.getJoinStatus() == JoinStatus.MARKED_FOR_JOINED) {
                throw new AssertionFailure("Transaction MARKED_FOR_JOINED after isOpen() call");
            }
            SynchronizationCallbackCoordinator callbackCoordinator = transactionCoordinator.getSynchronizationCallbackCoordinator();
            callbackCoordinator.setManagedFlushChecker((ManagedFlushChecker)new ManagedFlushCheckerImpl());
            callbackCoordinator.setExceptionMapper((ExceptionMapper)new CallbackExceptionMapperImpl());
            callbackCoordinator.setAfterCompletionAction((AfterCompletionAction)new AfterCompletionActionImpl(session, this.transactionType));
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public Object getDelegate() {
        this.checkOpen();
        return this.internalGetSession();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.tx = new TransactionImpl(this);
    }

    @Override
    public void handlePersistenceException(PersistenceException e) {
        if (e instanceof NoResultException) {
            return;
        }
        if (e instanceof javax.persistence.NonUniqueResultException) {
            return;
        }
        if (e instanceof javax.persistence.LockTimeoutException) {
            return;
        }
        if (e instanceof javax.persistence.QueryTimeoutException) {
            return;
        }
        try {
            this.markAsRollback();
        }
        catch (Exception ne) {
            LOG.unableToMarkForRollbackOnPersistenceException(ne);
        }
    }

    @Override
    public void throwPersistenceException(PersistenceException e) {
        this.handlePersistenceException(e);
        throw e;
    }

    @Override
    public RuntimeException convert(HibernateException e) {
        return this.convert(e, null);
    }

    public RuntimeException convert(RuntimeException e) {
        RuntimeException result = e;
        if (e instanceof HibernateException) {
            result = this.convert((HibernateException)((Object)e));
        } else {
            this.markAsRollback();
        }
        return result;
    }

    @Override
    public RuntimeException convert(HibernateException e, LockOptions lockOptions) {
        if (e instanceof StaleStateException) {
            PersistenceException converted = this.wrapStaleStateException((StaleStateException)e);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof LockingStrategyException) {
            PersistenceException converted = this.wrapLockException(e, lockOptions);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof LockTimeoutException) {
            PersistenceException converted = this.wrapLockException(e, lockOptions);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof PessimisticLockException) {
            PersistenceException converted = this.wrapLockException(e, lockOptions);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof QueryTimeoutException) {
            javax.persistence.QueryTimeoutException converted = new javax.persistence.QueryTimeoutException(e.getMessage(), (Throwable)e);
            this.handlePersistenceException((PersistenceException)converted);
            return converted;
        }
        if (e instanceof ObjectNotFoundException) {
            EntityNotFoundException converted = new EntityNotFoundException(e.getMessage());
            this.handlePersistenceException((PersistenceException)converted);
            return converted;
        }
        if (e instanceof NonUniqueObjectException) {
            EntityExistsException converted = new EntityExistsException(e.getMessage());
            this.handlePersistenceException((PersistenceException)converted);
            return converted;
        }
        if (e instanceof NonUniqueResultException) {
            javax.persistence.NonUniqueResultException converted = new javax.persistence.NonUniqueResultException(e.getMessage());
            this.handlePersistenceException((PersistenceException)converted);
            return converted;
        }
        if (e instanceof UnresolvableObjectException) {
            EntityNotFoundException converted = new EntityNotFoundException(e.getMessage());
            this.handlePersistenceException((PersistenceException)converted);
            return converted;
        }
        if (e instanceof QueryException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof TransientObjectException) {
            try {
                this.markAsRollback();
            }
            catch (Exception ne) {
                LOG.unableToMarkForRollbackOnTransientObjectException(ne);
            }
            return new IllegalStateException(e);
        }
        PersistenceException converted = new PersistenceException((Throwable)e);
        this.handlePersistenceException(converted);
        return converted;
    }

    @Override
    public void throwPersistenceException(HibernateException e) {
        throw this.convert(e);
    }

    @Override
    public PersistenceException wrapStaleStateException(StaleStateException e) {
        OptimisticLockException pe;
        block7: {
            if (e instanceof StaleObjectStateException) {
                StaleObjectStateException sose = (StaleObjectStateException)e;
                Serializable identifier = sose.getIdentifier();
                if (identifier != null) {
                    try {
                        Object entity = this.internalGetSession().load(sose.getEntityName(), identifier);
                        if (entity instanceof Serializable) {
                            pe = new OptimisticLockException(null, (Throwable)e, entity);
                            break block7;
                        }
                        pe = new OptimisticLockException((Throwable)e);
                    }
                    catch (EntityNotFoundException enfe) {
                        pe = new OptimisticLockException((Throwable)e);
                    }
                } else {
                    pe = new OptimisticLockException((Throwable)e);
                }
            } else {
                pe = new OptimisticLockException((Throwable)e);
            }
        }
        return pe;
    }

    public PersistenceException wrapLockException(HibernateException e, LockOptions lockOptions) {
        Object pe;
        if (e instanceof OptimisticEntityLockException) {
            OptimisticEntityLockException lockException = (OptimisticEntityLockException)e;
            pe = new OptimisticLockException(lockException.getMessage(), (Throwable)lockException, lockException.getEntity());
        } else if (e instanceof LockTimeoutException) {
            pe = new javax.persistence.LockTimeoutException(e.getMessage(), (Throwable)e, null);
        } else if (e instanceof PessimisticEntityLockException) {
            PessimisticEntityLockException lockException = (PessimisticEntityLockException)e;
            pe = lockOptions != null && lockOptions.getTimeOut() > -1 ? new javax.persistence.LockTimeoutException(lockException.getMessage(), (Throwable)lockException, lockException.getEntity()) : new javax.persistence.PessimisticLockException(lockException.getMessage(), (Throwable)lockException, lockException.getEntity());
        } else if (e instanceof PessimisticLockException) {
            PessimisticLockException jdbcLockException = (PessimisticLockException)e;
            pe = lockOptions != null && lockOptions.getTimeOut() > -1 ? new javax.persistence.LockTimeoutException(jdbcLockException.getMessage(), (Throwable)jdbcLockException, null) : new javax.persistence.PessimisticLockException(jdbcLockException.getMessage(), (Throwable)jdbcLockException, null);
        } else {
            pe = new OptimisticLockException((Throwable)e);
        }
        return pe;
    }

    static {
        entityManagerSpecificProperties.add("javax.persistence.lock.scope");
        entityManagerSpecificProperties.add("javax.persistence.lock.timeout");
        entityManagerSpecificProperties.add("org.hibernate.flushMode");
        entityManagerSpecificProperties.add("javax.persistence.cache.retrieveMode");
        entityManagerSpecificProperties.add("javax.persistence.cache.storeMode");
        entityManagerSpecificProperties.add("javax.persistence.query.timeout");
    }

    private class CallbackExceptionMapperImpl
    implements ExceptionMapper {
        private CallbackExceptionMapperImpl() {
        }

        public RuntimeException mapStatusCheckFailure(String message, SystemException systemException) {
            throw new PersistenceException(message, (Throwable)systemException);
        }

        public RuntimeException mapManagedFlushFailure(String message, RuntimeException failure) {
            if (HibernateException.class.isInstance(failure)) {
                throw AbstractEntityManagerImpl.this.convert(failure);
            }
            if (PersistenceException.class.isInstance(failure)) {
                throw failure;
            }
            throw new PersistenceException(message, (Throwable)failure);
        }
    }

    private static class ManagedFlushCheckerImpl
    implements ManagedFlushChecker {
        private ManagedFlushCheckerImpl() {
        }

        public boolean shouldDoManagedFlush(TransactionCoordinator coordinator, int jtaStatus) {
            return !coordinator.getTransactionContext().isClosed() && !coordinator.getTransactionContext().isFlushModeNever() && !JtaStatusHelper.isRollback((int)jtaStatus);
        }
    }

    private static class AfterCompletionActionImpl
    implements AfterCompletionAction {
        private final SessionImplementor session;
        private final PersistenceUnitTransactionType transactionType;

        private AfterCompletionActionImpl(SessionImplementor session, PersistenceUnitTransactionType transactionType) {
            this.session = session;
            this.transactionType = transactionType;
        }

        public void doAction(TransactionCoordinator transactionCoordinator, int status) {
            if (this.session.isClosed()) {
                LOG.trace("Session was closed; nothing to do");
                return;
            }
            boolean successful = JtaStatusHelper.isCommitted((int)status);
            if (!successful && this.transactionType == PersistenceUnitTransactionType.JTA) {
                ((Session)this.session).clear();
            }
            this.session.getTransactionCoordinator().resetJoinStatus();
        }
    }

    private static class CriteriaQueryTransformer
    extends BasicTransformerAdapter {
        private final List<ValueHandlerFactory.ValueHandler> valueHandlers;
        private final List tupleElements;

        private CriteriaQueryTransformer(List<ValueHandlerFactory.ValueHandler> valueHandlers, List tupleElements) {
            this.valueHandlers = valueHandlers;
            this.tupleElements = tupleElements;
        }

        public Object transformTuple(Object[] tuple, String[] aliases) {
            Object[] valueHandlerResult;
            if (this.valueHandlers == null) {
                valueHandlerResult = tuple;
            } else {
                valueHandlerResult = new Object[tuple.length];
                for (int i = 0; i < tuple.length; ++i) {
                    ValueHandlerFactory.ValueHandler valueHandler = this.valueHandlers.get(i);
                    valueHandlerResult[i] = valueHandler == null ? tuple[i] : valueHandler.convert(tuple[i]);
                }
            }
            return this.tupleElements == null ? (valueHandlerResult.length == 1 ? valueHandlerResult[0] : valueHandlerResult) : new TupleImpl(tuple);
        }

        private class TupleImpl
        implements Tuple {
            private final Object[] tuples;

            private TupleImpl(Object[] tuples) {
                if (tuples.length != CriteriaQueryTransformer.this.tupleElements.size()) {
                    throw new IllegalArgumentException("Size mismatch between tuple result [" + tuples.length + "] and expected tuple elements [" + CriteriaQueryTransformer.this.tupleElements.size() + "]");
                }
                this.tuples = tuples;
            }

            public <X> X get(TupleElement<X> tupleElement) {
                int index = CriteriaQueryTransformer.this.tupleElements.indexOf(tupleElement);
                if (index < 0) {
                    throw new IllegalArgumentException("Requested tuple element did not correspond to element in the result tuple");
                }
                return (X)this.tuples[index];
            }

            public Object get(String alias) {
                int index = -1;
                if (alias != null && (alias = alias.trim()).length() > 0) {
                    int i = 0;
                    for (TupleElement selection : CriteriaQueryTransformer.this.tupleElements) {
                        if (alias.equals(selection.getAlias())) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (index < 0) {
                    throw new IllegalArgumentException("Given alias [" + alias + "] did not correspond to an element in the result tuple");
                }
                return this.tuples[index];
            }

            public <X> X get(String alias, Class<X> type) {
                return (X)this.get(alias);
            }

            public Object get(int i) {
                if (i >= this.tuples.length) {
                    throw new IllegalArgumentException("Given index [" + i + "] was outside the range of result tuple size [" + this.tuples.length + "] ");
                }
                return this.tuples[i];
            }

            public <X> X get(int i, Class<X> type) {
                return (X)this.get(i);
            }

            public Object[] toArray() {
                return this.tuples;
            }

            public List<TupleElement<?>> getElements() {
                return CriteriaQueryTransformer.this.tupleElements;
            }
        }
    }

    public static class TupleBuilderTransformer
    extends BasicTransformerAdapter {
        private List<TupleElement<?>> tupleElements;
        private Map<String, HqlTupleElementImpl> tupleElementsByAlias;

        public TupleBuilderTransformer(Query hqlQuery) {
            Type[] resultTypes = hqlQuery.getReturnTypes();
            int tupleSize = resultTypes.length;
            this.tupleElements = CollectionHelper.arrayList((int)tupleSize);
            String[] aliases = hqlQuery.getReturnAliases();
            boolean hasAliases = aliases != null && aliases.length > 0;
            this.tupleElementsByAlias = hasAliases ? CollectionHelper.mapOfSize((int)tupleSize) : Collections.emptyMap();
            for (int i = 0; i < tupleSize; ++i) {
                String alias;
                HqlTupleElementImpl tupleElement = new HqlTupleElementImpl(i, aliases == null ? null : aliases[i], resultTypes[i]);
                this.tupleElements.add(tupleElement);
                if (!hasAliases || (alias = aliases[i]) == null) continue;
                this.tupleElementsByAlias.put(alias, tupleElement);
            }
        }

        public Object transformTuple(Object[] tuple, String[] aliases) {
            if (tuple.length != this.tupleElements.size()) {
                throw new IllegalArgumentException("Size mismatch between tuple result [" + tuple.length + "] and expected tuple elements [" + this.tupleElements.size() + "]");
            }
            return new HqlTupleImpl(tuple);
        }

        public class HqlTupleImpl
        implements Tuple {
            private Object[] tuple;

            public HqlTupleImpl(Object[] tuple) {
                this.tuple = tuple;
            }

            public <X> X get(String alias, Class<X> type) {
                return (X)this.get(alias);
            }

            public Object get(String alias) {
                HqlTupleElementImpl tupleElement = (HqlTupleElementImpl)TupleBuilderTransformer.this.tupleElementsByAlias.get(alias);
                if (tupleElement == null) {
                    throw new IllegalArgumentException("Unknown alias [" + alias + "]");
                }
                return this.tuple[tupleElement.getPosition()];
            }

            public <X> X get(int i, Class<X> type) {
                return (X)this.get(i);
            }

            public Object get(int i) {
                if (i < 0) {
                    throw new IllegalArgumentException("requested tuple index must be greater than zero");
                }
                if (i > this.tuple.length) {
                    throw new IllegalArgumentException("requested tuple index exceeds actual tuple size");
                }
                return this.tuple[i];
            }

            public Object[] toArray() {
                return this.tuple;
            }

            public List<TupleElement<?>> getElements() {
                return TupleBuilderTransformer.this.tupleElements;
            }

            public <X> X get(TupleElement<X> tupleElement) {
                if (HqlTupleElementImpl.class.isInstance(tupleElement)) {
                    return this.get(((HqlTupleElementImpl)tupleElement).getPosition(), tupleElement.getJavaType());
                }
                return this.get(tupleElement.getAlias(), tupleElement.getJavaType());
            }
        }

        public static class HqlTupleElementImpl<X>
        implements TupleElement<X> {
            private final int position;
            private final String alias;
            private final Type hibernateType;

            public HqlTupleElementImpl(int position, String alias, Type hibernateType) {
                this.position = position;
                this.alias = alias;
                this.hibernateType = hibernateType;
            }

            public Class getJavaType() {
                return this.hibernateType.getReturnedClass();
            }

            public String getAlias() {
                return this.alias;
            }

            public int getPosition() {
                return this.position;
            }

            public Type getHibernateType() {
                return this.hibernateType;
            }
        }
    }
}

