/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.schemagen;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.persistence.PersistenceException;
import org.hibernate.jpa.internal.schemagen.ReaderScriptSource;
import org.hibernate.jpa.internal.schemagen.SqlScriptReader;
import org.jboss.logging.Logger;

class FileScriptSource
extends ReaderScriptSource
implements SqlScriptReader {
    private static final Logger log = Logger.getLogger(FileScriptSource.class);

    public FileScriptSource(String fileUrl) {
        super(FileScriptSource.toFileReader(fileUrl));
    }

    @Override
    public void release() {
        try {
            this.reader().close();
        }
        catch (IOException e) {
            log.warn((Object)"Unable to close file reader for generation script source");
        }
    }

    private static Reader toFileReader(String fileUrl) {
        File file = new File(fileUrl);
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            log.debug((Object)("Exception calling File#createNewFile : " + e.toString()));
        }
        try {
            return new FileReader(file);
        }
        catch (IOException e) {
            throw new PersistenceException("Unable to open specified script target file for writing : " + fileUrl);
        }
    }
}

