/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.graph;

import java.util.List;
import javax.persistence.AttributeNode;
import javax.persistence.Subgraph;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.jpa.internal.graph.GraphNode;

public class SubgraphImpl<T>
extends GraphNode<T>
implements Subgraph<T> {
    private final ManagedType managedType;
    private final Class<T> subclass;

    public SubgraphImpl(HibernateEntityManagerFactory entityManagerFactory, ManagedType managedType, Class<T> subclass) {
        super(entityManagerFactory, true);
        this.managedType = managedType;
        this.subclass = subclass;
    }

    private SubgraphImpl(SubgraphImpl<T> original) {
        super(original, false);
        this.managedType = original.managedType;
        this.subclass = original.subclass;
    }

    public SubgraphImpl<T> makeImmutableCopy() {
        return new SubgraphImpl<T>(this);
    }

    @Override
    public void addAttributeNodes(String ... attributeNames) {
        super.addAttributeNodes(attributeNames);
    }

    @Override
    public void addAttributeNodes(Attribute<T, ?> ... attributes) {
        super.addAttributeNodes(attributes);
    }

    @Override
    public <X> Subgraph<X> addSubgraph(Attribute<T, X> attribute) {
        return super.addSubgraph(attribute);
    }

    @Override
    public <X> Subgraph<? extends X> addSubgraph(Attribute<T, X> attribute, Class<? extends X> type) {
        return super.addSubgraph(attribute, type);
    }

    @Override
    public <X> Subgraph<X> addSubgraph(String attributeName) {
        return super.addSubgraph(attributeName);
    }

    @Override
    public <X> Subgraph<X> addSubgraph(String attributeName, Class<X> type) {
        return super.addSubgraph(attributeName, type);
    }

    @Override
    public <X> Subgraph<X> addKeySubgraph(Attribute<T, X> attribute) {
        return super.addKeySubgraph(attribute);
    }

    @Override
    public <X> Subgraph<? extends X> addKeySubgraph(Attribute<T, X> attribute, Class<? extends X> type) {
        return super.addKeySubgraph(attribute, type);
    }

    @Override
    public <X> Subgraph<X> addKeySubgraph(String attributeName) {
        return super.addKeySubgraph(attributeName);
    }

    @Override
    public <X> Subgraph<X> addKeySubgraph(String attributeName, Class<X> type) {
        return super.addKeySubgraph(attributeName, type);
    }

    public Class<T> getClassType() {
        return this.managedType.getJavaType();
    }

    public List<AttributeNode<?>> getAttributeNodes() {
        return super.attributeNodes();
    }

    @Override
    protected Attribute<T, ?> resolveAttribute(String attributeName) {
        Attribute attribute = this.managedType.getDeclaredAttribute(attributeName);
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Given attribute name [%s] is not an attribute on this class [%s]", attributeName, this.managedType.getClass().getName()));
        }
        return attribute;
    }
}

