/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.Subgraph;
import javax.persistence.metamodel.Attribute;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.jpa.internal.graph.AttributeNodeImpl;
import org.jboss.logging.Logger;

public abstract class GraphNode<T> {
    private static final Logger log = Logger.getLogger(GraphNode.class);
    private final HibernateEntityManagerFactory entityManagerFactory;
    private final boolean mutable;
    private Map<String, AttributeNode<?>> attributeNodeMap;

    protected GraphNode(HibernateEntityManagerFactory entityManagerFactory, boolean mutable) {
        this.entityManagerFactory = entityManagerFactory;
        this.mutable = mutable;
    }

    protected GraphNode(GraphNode<T> original, boolean mutable) {
        this.entityManagerFactory = original.entityManagerFactory;
        this.mutable = mutable;
        this.attributeNodeMap = GraphNode.makeSafeMapCopy(original.attributeNodeMap);
    }

    private static Map<String, AttributeNode<?>> makeSafeMapCopy(Map<String, AttributeNode<?>> attributeNodeMap) {
        if (attributeNodeMap == null) {
            return null;
        }
        int properSize = CollectionHelper.determineProperSizing(attributeNodeMap);
        HashMap copy = new HashMap(properSize);
        for (Map.Entry<String, AttributeNode<?>> attributeNodeEntry : attributeNodeMap.entrySet()) {
            copy.put(attributeNodeEntry.getKey(), ((AttributeNodeImpl)attributeNodeEntry.getValue()).makeImmutableCopy());
        }
        return copy;
    }

    protected HibernateEntityManagerFactory entityManagerFactory() {
        return this.entityManagerFactory;
    }

    protected List<AttributeNode<?>> attributeNodes() {
        if (this.attributeNodeMap == null) {
            return Collections.emptyList();
        }
        return new ArrayList(this.attributeNodeMap.values());
    }

    protected void addAttributeNodes(String ... attributeNames) {
        for (String attributeName : attributeNames) {
            this.addAttribute(attributeName);
        }
    }

    protected AttributeNodeImpl addAttribute(String attributeName) {
        return this.addAttributeNode(this.buildAttributeNode(attributeName));
    }

    private AttributeNodeImpl<?> buildAttributeNode(String attributeName) {
        return this.buildAttributeNode(this.resolveAttribute(attributeName));
    }

    protected abstract Attribute<T, ?> resolveAttribute(String var1);

    protected AttributeNodeImpl<?> buildAttributeNode(Attribute<T, ?> attribute) {
        return new AttributeNodeImpl(this.entityManagerFactory, attribute);
    }

    protected AttributeNodeImpl addAttributeNode(AttributeNodeImpl attributeNode) {
        if (!this.mutable) {
            throw new IllegalStateException("Entity/sub graph is not mutable");
        }
        if (this.attributeNodeMap == null) {
            this.attributeNodeMap = new HashMap();
        } else {
            AttributeNode<?> old = this.attributeNodeMap.get(attributeNode.getRegistrationName());
            if (old != null) {
                log.debugf("Encountered request to add entity graph node [%s] using a name [%s] under which another node is already registered [%s]", (Object)old.getClass().getName(), (Object)attributeNode.getRegistrationName(), (Object)attributeNode.getClass().getName());
            }
        }
        this.attributeNodeMap.put(attributeNode.getRegistrationName(), attributeNode);
        return attributeNode;
    }

    protected void addAttributeNodes(Attribute<T, ?> ... attributes) {
        for (Attribute<T, ?> attribute : attributes) {
            this.addAttribute(attribute);
        }
    }

    protected AttributeNodeImpl addAttribute(Attribute attribute) {
        return this.addAttributeNode(this.buildAttributeNode(attribute));
    }

    public <X> Subgraph<X> addSubgraph(Attribute<T, X> attribute) {
        return this.addAttribute(attribute).makeSubgraph();
    }

    public <X> Subgraph<? extends X> addSubgraph(Attribute<T, X> attribute, Class<? extends X> type) {
        return this.addAttribute(attribute).makeSubgraph(type);
    }

    public <X> Subgraph<X> addSubgraph(String attributeName) {
        return this.addAttribute(attributeName).makeSubgraph();
    }

    public <X> Subgraph<X> addSubgraph(String attributeName, Class<X> type) {
        return this.addAttribute(attributeName).makeSubgraph(type);
    }

    public <X> Subgraph<X> addKeySubgraph(Attribute<T, X> attribute) {
        return this.addAttribute(attribute).makeKeySubgraph();
    }

    public <X> Subgraph<? extends X> addKeySubgraph(Attribute<T, X> attribute, Class<? extends X> type) {
        return this.addAttribute(attribute).makeKeySubgraph(type);
    }

    public <X> Subgraph<X> addKeySubgraph(String attributeName) {
        return this.addAttribute(attributeName).makeKeySubgraph();
    }

    public <X> Subgraph<X> addKeySubgraph(String attributeName, Class<X> type) {
        return this.addAttribute(attributeName).makeKeySubgraph(type);
    }
}

