/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.hibernate.ejb.EntityManagerLogger;
import org.hibernate.ejb.packaging.AbstractJarVisitor;
import org.hibernate.ejb.packaging.Filter;
import org.jboss.logging.Logger;

public class ExplodedJarVisitor
extends AbstractJarVisitor {
    private static final EntityManagerLogger LOG = (EntityManagerLogger)Logger.getMessageLogger(EntityManagerLogger.class, (String)ExplodedJarVisitor.class.getName());
    private String entry;

    public ExplodedJarVisitor(URL url, Filter[] filters, String entry) {
        super(url, filters);
        this.entry = entry;
    }

    public ExplodedJarVisitor(String fileName, Filter[] filters) {
        super(fileName, filters);
    }

    @Override
    protected void doProcessElements() throws IOException {
        File jarFile;
        try {
            String filePart = this.jarUrl.getFile();
            jarFile = filePart != null && filePart.indexOf(32) != -1 ? new File(this.jarUrl.getFile()) : new File(this.jarUrl.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            LOG.malformedUrl(this.jarUrl, e);
            return;
        }
        if (!jarFile.exists()) {
            LOG.explodedJarDoesNotExist(this.jarUrl);
            return;
        }
        if (!jarFile.isDirectory()) {
            LOG.explodedJarNotDirectory(this.jarUrl);
            return;
        }
        File rootFile = this.entry != null && this.entry.length() > 0 && !"/".equals(this.entry) ? new File(jarFile, this.entry) : jarFile;
        if (rootFile.isDirectory()) {
            this.getClassNamesInTree(rootFile, null);
        } else {
            this.processZippedRoot(rootFile);
        }
    }

    private void processZippedRoot(File rootFile) throws IOException {
        JarFile jarFile = new JarFile(rootFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = zipEntry.getName();
            if (zipEntry.isDirectory()) continue;
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            this.addElement(name, new BufferedInputStream(jarFile.getInputStream(zipEntry)), new BufferedInputStream(jarFile.getInputStream(zipEntry)));
        }
    }

    private void getClassNamesInTree(File jarFile, String header) throws IOException {
        File[] files = jarFile.listFiles();
        header = header == null ? "" : header + "/";
        for (File localFile : files) {
            if (!localFile.isDirectory()) {
                String entryName = localFile.getName();
                this.addElement(header + entryName, new BufferedInputStream(new FileInputStream(localFile)), new BufferedInputStream(new FileInputStream(localFile)));
                continue;
            }
            this.getClassNamesInTree(localFile, header + localFile.getName());
        }
    }
}

