/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.spi;

import java.util.Map;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.JpaCompliance;

public class JpaComplianceImpl
implements JpaCompliance {
    private boolean queryCompliance;
    private boolean transactionCompliance;
    private boolean listCompliance;
    private boolean closedCompliance;
    private boolean proxyCompliance;
    private boolean cachingCompliance;

    public JpaComplianceImpl(Map configurationSettings, boolean jpaByDefault) {
        Object legacyQueryCompliance = configurationSettings.get("hibernate.query.jpaql_strict_compliance");
        this.queryCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.query", configurationSettings, ConfigurationHelper.toBoolean(legacyQueryCompliance, jpaByDefault));
        this.transactionCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.transaction", configurationSettings, jpaByDefault);
        this.listCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.list", configurationSettings, jpaByDefault);
        this.closedCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.closed", configurationSettings, jpaByDefault);
        this.proxyCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.proxy", configurationSettings, jpaByDefault);
        this.cachingCompliance = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.caching", configurationSettings, jpaByDefault);
    }

    @Override
    public boolean isJpaQueryComplianceEnabled() {
        return this.queryCompliance;
    }

    @Override
    public boolean isJpaTransactionComplianceEnabled() {
        return this.transactionCompliance;
    }

    @Override
    public boolean isJpaListComplianceEnabled() {
        return this.listCompliance;
    }

    @Override
    public boolean isJpaClosedComplianceEnabled() {
        return this.closedCompliance;
    }

    @Override
    public boolean isJpaProxyComplianceEnabled() {
        return this.proxyCompliance;
    }

    @Override
    public boolean isJpaCacheComplianceEnabled() {
        return this.cachingCompliance;
    }

    public void setQueryCompliance(boolean queryCompliance) {
        this.queryCompliance = queryCompliance;
    }

    public void setTransactionCompliance(boolean transactionCompliance) {
        this.transactionCompliance = transactionCompliance;
    }

    public void setListCompliance(boolean listCompliance) {
        this.listCompliance = listCompliance;
    }

    public void setClosedCompliance(boolean closedCompliance) {
        this.closedCompliance = closedCompliance;
    }

    public void setProxyCompliance(boolean proxyCompliance) {
        this.proxyCompliance = proxyCompliance;
    }

    public void setCachingCompliance(boolean cachingCompliance) {
        this.cachingCompliance = cachingCompliance;
    }
}

