/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.spi;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.jpa.event.internal.CallbackBuilderLegacyImpl;
import org.hibernate.jpa.event.internal.CallbackRegistryImpl;
import org.hibernate.jpa.event.internal.core.HibernateEntityManagerEventListener;
import org.hibernate.jpa.event.internal.core.JpaAutoFlushEventListener;
import org.hibernate.jpa.event.internal.core.JpaDeleteEventListener;
import org.hibernate.jpa.event.internal.core.JpaFlushEntityEventListener;
import org.hibernate.jpa.event.internal.core.JpaFlushEventListener;
import org.hibernate.jpa.event.internal.core.JpaMergeEventListener;
import org.hibernate.jpa.event.internal.core.JpaPersistEventListener;
import org.hibernate.jpa.event.internal.core.JpaPersistOnFlushEventListener;
import org.hibernate.jpa.event.internal.core.JpaPostDeleteEventListener;
import org.hibernate.jpa.event.internal.core.JpaPostInsertEventListener;
import org.hibernate.jpa.event.internal.core.JpaPostLoadEventListener;
import org.hibernate.jpa.event.internal.core.JpaPostUpdateEventListener;
import org.hibernate.jpa.event.internal.core.JpaSaveEventListener;
import org.hibernate.jpa.event.internal.core.JpaSaveOrUpdateEventListener;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class JpaIntegrator
implements Integrator {
    private CallbackRegistryImpl callbackRegistry;
    private CascadeStyle oldPersistCascadeStyle;
    private static final DuplicationStrategy JPA_DUPLICATION_STRATEGY = new JPADuplicationStrategy();

    @Override
    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        try {
            this.oldPersistCascadeStyle = CascadeStyles.getCascadeStyle("persist");
        }
        catch (Exception exception) {
            // empty catch block
        }
        CascadeStyles.registerCascadeStyle("persist", new PersistCascadeStyle());
        EventListenerRegistry eventListenerRegistry = serviceRegistry.getService(EventListenerRegistry.class);
        eventListenerRegistry.addDuplicationStrategy(JPA_DUPLICATION_STRATEGY);
        eventListenerRegistry.setListeners(EventType.AUTO_FLUSH, JpaAutoFlushEventListener.INSTANCE);
        eventListenerRegistry.setListeners(EventType.DELETE, new JpaDeleteEventListener());
        eventListenerRegistry.setListeners(EventType.FLUSH_ENTITY, new JpaFlushEntityEventListener());
        eventListenerRegistry.setListeners(EventType.FLUSH, JpaFlushEventListener.INSTANCE);
        eventListenerRegistry.setListeners(EventType.MERGE, new JpaMergeEventListener());
        eventListenerRegistry.setListeners(EventType.PERSIST, new JpaPersistEventListener());
        eventListenerRegistry.setListeners(EventType.PERSIST_ONFLUSH, new JpaPersistOnFlushEventListener());
        eventListenerRegistry.setListeners(EventType.SAVE, new JpaSaveEventListener());
        eventListenerRegistry.setListeners(EventType.SAVE_UPDATE, new JpaSaveOrUpdateEventListener());
        eventListenerRegistry.prependListeners(EventType.POST_DELETE, new JpaPostDeleteEventListener());
        eventListenerRegistry.prependListeners(EventType.POST_INSERT, new JpaPostInsertEventListener());
        eventListenerRegistry.prependListeners(EventType.POST_LOAD, new JpaPostLoadEventListener());
        eventListenerRegistry.prependListeners(EventType.POST_UPDATE, new JpaPostUpdateEventListener());
        ConfigurationService cfgService = serviceRegistry.getService(ConfigurationService.class);
        for (Map.Entry entry : cfgService.getSettings().entrySet()) {
            String propertyName;
            if (!String.class.isInstance(entry.getKey()) || !(propertyName = (String)entry.getKey()).startsWith("hibernate.ejb.event")) continue;
            String eventTypeName = propertyName.substring("hibernate.ejb.event".length() + 1);
            EventType eventType = EventType.resolveEventTypeByName(eventTypeName);
            EventListenerGroup<Object> eventListenerGroup = eventListenerRegistry.getEventListenerGroup(eventType);
            for (String listenerImpl : ((String)entry.getValue()).split(" ,")) {
                eventListenerGroup.appendListener(this.instantiate(listenerImpl, serviceRegistry));
            }
        }
        ReflectionManager reflectionManager = ((MetadataImpl)metadata).getMetadataBuildingOptions().getReflectionManager();
        this.callbackRegistry = new CallbackRegistryImpl();
        CallbackBuilderLegacyImpl callbackBuilder = new CallbackBuilderLegacyImpl(serviceRegistry.getService(ManagedBeanRegistry.class), reflectionManager);
        for (PersistentClass persistentClass : metadata.getEntityBindings()) {
            if (persistentClass.getClassName() == null) continue;
            callbackBuilder.buildCallbacksForEntity(persistentClass.getClassName(), this.callbackRegistry);
        }
        for (EventType eventType : EventType.values()) {
            EventListenerGroup eventListenerGroup = eventListenerRegistry.getEventListenerGroup(eventType);
            for (Object listener : eventListenerGroup.listeners()) {
                if (!CallbackRegistryConsumer.class.isInstance(listener)) continue;
                ((CallbackRegistryConsumer)listener).injectCallbackRegistry(this.callbackRegistry);
            }
        }
    }

    @Override
    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (this.oldPersistCascadeStyle == null) {
            CascadeStyles.registerCascadeStyle("persist", null);
        }
        CascadeStyles.registerCascadeStyle("persist", (CascadeStyles.BaseCascadeStyle)this.oldPersistCascadeStyle);
        if (this.callbackRegistry != null) {
            this.callbackRegistry.release();
        }
    }

    private Object instantiate(String listenerImpl, ServiceRegistryImplementor serviceRegistry) {
        try {
            return serviceRegistry.getService(ClassLoaderService.class).classForName(listenerImpl).newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate requested listener [" + listenerImpl + "]", e);
        }
    }

    private static class JPADuplicationStrategy
    implements DuplicationStrategy {
        private JPADuplicationStrategy() {
        }

        @Override
        public boolean areMatch(Object listener, Object original) {
            return listener.getClass().equals(original.getClass()) && HibernateEntityManagerEventListener.class.isInstance(original);
        }

        @Override
        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.KEEP_ORIGINAL;
        }
    }

    private static class PersistCascadeStyle
    extends CascadeStyles.BaseCascadeStyle {
        private PersistCascadeStyle() {
        }

        @Override
        public boolean doCascade(CascadingAction action) {
            return action == JpaPersistEventListener.PERSIST_SKIPLAZY || action == CascadingActions.PERSIST_ON_FLUSH;
        }

        public String toString() {
            return "STYLE_PERSIST_SKIPLAZY";
        }
    }
}

