/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.internal;

import javax.transaction.Synchronization;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.jpa.JpaCompliance;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.jboss.logging.Logger;

public class TransactionImpl
implements TransactionImplementor {
    private static final Logger LOG = CoreLogging.logger(TransactionImpl.class);
    private final TransactionCoordinator transactionCoordinator;
    private final ExceptionConverter exceptionConverter;
    private final JpaCompliance jpaCompliance;
    private TransactionCoordinator.TransactionDriver transactionDriverControl;

    public TransactionImpl(TransactionCoordinator transactionCoordinator, ExceptionConverter exceptionConverter, JpaCompliance jpaCompliance) {
        this.transactionCoordinator = transactionCoordinator;
        this.exceptionConverter = exceptionConverter;
        this.jpaCompliance = jpaCompliance;
        this.transactionDriverControl = transactionCoordinator.getTransactionDriverControl();
        LOG.debugf("On TransactionImpl creation, JpaCompliance#isJpaTransactionComplianceEnabled == %s", (Object)jpaCompliance.isJpaTransactionComplianceEnabled());
    }

    public void begin() {
        if (!this.transactionCoordinator.isActive()) {
            throw new TransactionException("Cannot begin Transaction on closed Session/EntityManager");
        }
        if (this.transactionDriverControl == null) {
            this.transactionDriverControl = this.transactionCoordinator.getTransactionDriverControl();
        }
        if (this.isActive()) {
            throw new IllegalStateException("Transaction already active");
        }
        LOG.debug((Object)"begin");
        this.transactionDriverControl.begin();
    }

    public void commit() {
        if (!this.isActive(true)) {
            throw new IllegalStateException("Transaction not successfully started");
        }
        LOG.debug((Object)"committing");
        try {
            this.internalGetTransactionDriverControl().commit();
        }
        catch (RuntimeException e) {
            throw this.exceptionConverter.convertCommitException(e);
        }
    }

    public TransactionCoordinator.TransactionDriver internalGetTransactionDriverControl() {
        if (this.transactionDriverControl == null) {
            throw new IllegalStateException("Transaction was not properly begun/started");
        }
        return this.transactionDriverControl;
    }

    public void rollback() {
        if (this.jpaCompliance.isJpaTransactionComplianceEnabled() && !this.isActive()) {
            throw new IllegalStateException("JPA compliance dictates throwing IllegalStateException when #rollback is called on non-active transaction");
        }
        TransactionStatus status = this.getStatus();
        if (status == TransactionStatus.ROLLED_BACK || status == TransactionStatus.NOT_ACTIVE) {
            LOG.debug((Object)"rollback() called on an inactive transaction");
            return;
        }
        if (!status.canRollback()) {
            throw new TransactionException("Cannot rollback transaction in current status [" + status.name() + "]");
        }
        LOG.debug((Object)"rolling back");
        if (status != TransactionStatus.FAILED_COMMIT || this.allowFailedCommitToPhysicallyRollback()) {
            this.internalGetTransactionDriverControl().rollback();
        }
    }

    public boolean isActive() {
        return this.isActive(true);
    }

    @Override
    public boolean isActive(boolean isMarkedForRollbackConsideredActive) {
        if (this.transactionDriverControl == null) {
            this.transactionDriverControl = this.transactionCoordinator.getTransactionDriverControl();
        }
        return this.transactionDriverControl.isActive(isMarkedForRollbackConsideredActive);
    }

    @Override
    public TransactionStatus getStatus() {
        if (this.transactionDriverControl == null) {
            this.transactionDriverControl = this.transactionCoordinator.getTransactionDriverControl();
        }
        return this.transactionDriverControl.getStatus();
    }

    @Override
    public void registerSynchronization(Synchronization synchronization) throws HibernateException {
        this.transactionCoordinator.getLocalSynchronizations().registerSynchronization(synchronization);
    }

    @Override
    public void setTimeout(int seconds) {
        this.transactionCoordinator.setTimeOut(seconds);
    }

    @Override
    public int getTimeout() {
        return this.transactionCoordinator.getTimeOut();
    }

    @Override
    public void markRollbackOnly() {
        this.internalGetTransactionDriverControl().markRollbackOnly();
    }

    public void setRollbackOnly() {
        if (this.jpaCompliance.isJpaTransactionComplianceEnabled() && !this.isActive()) {
            throw new IllegalStateException("JPA compliance dictates throwing IllegalStateException when #setRollbackOnly is called on non-active transaction");
        }
        this.markRollbackOnly();
    }

    public boolean getRollbackOnly() {
        if (this.jpaCompliance.isJpaTransactionComplianceEnabled() && !this.isActive()) {
            throw new IllegalStateException("JPA compliance dictates throwing IllegalStateException when #getRollbackOnly is called on non-active transaction");
        }
        return this.getStatus() == TransactionStatus.MARKED_ROLLBACK;
    }

    protected boolean allowFailedCommitToPhysicallyRollback() {
        return false;
    }
}

