/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCommitInsertEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityInsertAction
extends AbstractEntityInsertAction {
    private Object version;
    private Object cacheEntry;

    public EntityInsertAction(Serializable id, Object[] state, Object instance, Object version, EntityPersister persister, boolean isVersionIncrementDisabled, SharedSessionContractImplementor session) {
        super(id, state, instance, isVersionIncrementDisabled, persister, session);
        this.version = version;
    }

    @Override
    public boolean isEarlyInsert() {
        return false;
    }

    @Override
    protected EntityKey getEntityKey() {
        return this.getSession().generateEntityKey(this.getId(), this.getPersister());
    }

    @Override
    public void execute() throws HibernateException {
        this.nullifyTransientReferencesIfNotAlready();
        EntityPersister persister = this.getPersister();
        SharedSessionContractImplementor session = this.getSession();
        Object instance = this.getInstance();
        Serializable id = this.getId();
        boolean veto = this.preInsert();
        if (!veto) {
            persister.insert(id, this.getState(), instance, session);
            PersistenceContext persistenceContext = session.getPersistenceContext();
            EntityEntry entry = persistenceContext.getEntry(instance);
            if (entry == null) {
                throw new AssertionFailure("possible non-threadsafe access to session");
            }
            entry.postInsert(this.getState());
            if (persister.hasInsertGeneratedProperties()) {
                persister.processInsertGeneratedProperties(id, instance, this.getState(), session);
                if (persister.isVersionPropertyGenerated()) {
                    this.version = Versioning.getVersion(this.getState(), persister);
                }
                entry.postUpdate(instance, this.getState(), this.version);
            }
            persistenceContext.registerInsertedKey(persister, this.getId());
        }
        SessionFactoryImplementor factory = session.getFactory();
        if (this.isCachePutEnabled(persister, session)) {
            CacheEntry ce = persister.buildCacheEntry(instance, this.getState(), this.version, session);
            this.cacheEntry = persister.getCacheEntryStructure().structure(ce);
            EntityRegionAccessStrategy cache = persister.getCacheAccessStrategy();
            Object ck = cache.generateCacheKey(id, persister, factory, session.getTenantIdentifier());
            boolean put = this.cacheInsert(persister, ck);
            if (put && factory.getStatistics().isStatisticsEnabled()) {
                factory.getStatistics().secondLevelCachePut(cache.getRegion().getName());
            }
        }
        this.handleNaturalIdPostSaveNotifications(id);
        this.postInsert();
        if (factory.getStatistics().isStatisticsEnabled() && !veto) {
            factory.getStatistics().insertEntity(this.getPersister().getEntityName());
        }
        this.markExecuted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheInsert(EntityPersister persister, Object ck) {
        SharedSessionContractImplementor session = this.getSession();
        try {
            session.getEventListenerManager().cachePutStart();
            boolean bl = persister.getCacheAccessStrategy().insert(session, ck, this.cacheEntry, this.version);
            return bl;
        }
        finally {
            session.getEventListenerManager().cachePutEnd();
        }
    }

    private void postInsert() {
        EventListenerGroup<PostInsertEventListener> listenerGroup = this.listenerGroup(EventType.POST_INSERT);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostInsertEvent event = new PostInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getPersister(), this.eventSource());
        for (PostInsertEventListener listener : listenerGroup.listeners()) {
            listener.onPostInsert(event);
        }
    }

    private void postCommitInsert(boolean success) {
        EventListenerGroup<PostInsertEventListener> listenerGroup = this.listenerGroup(EventType.POST_COMMIT_INSERT);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostInsertEvent event = new PostInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getPersister(), this.eventSource());
        for (PostInsertEventListener listener : listenerGroup.listeners()) {
            if (PostCommitInsertEventListener.class.isInstance(listener)) {
                if (success) {
                    listener.onPostInsert(event);
                    continue;
                }
                ((PostCommitInsertEventListener)listener).onPostInsertCommitFailed(event);
                continue;
            }
            listener.onPostInsert(event);
        }
    }

    private boolean preInsert() {
        boolean veto = false;
        EventListenerGroup<PreInsertEventListener> listenerGroup = this.listenerGroup(EventType.PRE_INSERT);
        if (listenerGroup.isEmpty()) {
            return veto;
        }
        PreInsertEvent event = new PreInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getPersister(), this.eventSource());
        for (PreInsertEventListener listener : listenerGroup.listeners()) {
            veto |= listener.onPreInsert(event);
        }
        return veto;
    }

    @Override
    public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor session) throws HibernateException {
        EntityPersister persister = this.getPersister();
        if (success && this.isCachePutEnabled(persister, this.getSession())) {
            EntityRegionAccessStrategy cache = persister.getCacheAccessStrategy();
            SessionFactoryImplementor sessionFactoryImplementor = session.getFactory();
            Object ck = cache.generateCacheKey(this.getId(), persister, sessionFactoryImplementor, session.getTenantIdentifier());
            boolean put = this.cacheAfterInsert(cache, ck);
            if (put && sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                sessionFactoryImplementor.getStatisticsImplementor().secondLevelCachePut(cache.getRegion().getName());
            }
        }
        this.postCommitInsert(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheAfterInsert(EntityRegionAccessStrategy cache, Object ck) {
        SharedSessionContractImplementor session = this.getSession();
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        try {
            eventListenerManager.cachePutStart();
            boolean bl = cache.afterInsert(session, ck, this.cacheEntry, this.version);
            return bl;
        }
        finally {
            eventListenerManager.cachePutEnd();
        }
    }

    @Override
    protected boolean hasPostCommitEventListeners() {
        EventListenerGroup<PostInsertEventListener> group = this.listenerGroup(EventType.POST_COMMIT_INSERT);
        for (PostInsertEventListener listener : group.listeners()) {
            if (!listener.requiresPostCommitHandling(this.getPersister())) continue;
            return true;
        }
        return false;
    }

    private boolean isCachePutEnabled(EntityPersister persister, SharedSessionContractImplementor session) {
        return persister.canWriteToCache() && !persister.isCacheInvalidationRequired() && session.getCacheMode().isPutEnabled();
    }
}

