/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.procedure.internal;

import javax.persistence.TemporalType;
import org.hibernate.query.procedure.spi.ProcedureParameterBindingImplementor;
import org.hibernate.query.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.type.Type;

public class ProcedureParameterBindingImpl<T>
implements ProcedureParameterBindingImplementor<T> {
    private final ProcedureParameterImplementor<T> parameter;

    public ProcedureParameterBindingImpl(ProcedureParameterImplementor<T> parameter) {
        this.parameter = parameter;
    }

    @Override
    public boolean isBound() {
        return this.parameter.getNativeParameterRegistration().getBind() != null;
    }

    @Override
    public void setBindValue(T value) {
        this.parameter.getNativeParameterRegistration().bindValue(value);
    }

    @Override
    public void setBindValue(T value, Type clarifiedType) {
        this.parameter.getNativeParameterRegistration().setHibernateType(clarifiedType);
        this.parameter.getNativeParameterRegistration().bindValue(value);
    }

    @Override
    public void setBindValue(T value, TemporalType clarifiedTemporalType) {
        this.parameter.getNativeParameterRegistration().bindValue(value, clarifiedTemporalType);
    }

    @Override
    public T getBindValue() {
        return this.parameter.getNativeParameterRegistration().getBind().getValue();
    }

    @Override
    public Type getBindType() {
        return this.parameter.getNativeParameterRegistration().getHibernateType();
    }
}

