/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.mapping.Array;
import org.jboss.logging.Logger;

public class JdbcTypeJavaClassMappings {
    private static final Logger log = Logger.getLogger(JdbcTypeJavaClassMappings.class);
    public static final JdbcTypeJavaClassMappings INSTANCE = new JdbcTypeJavaClassMappings();
    private final ConcurrentHashMap<Class, Integer> javaClassToJdbcTypeCodeMap = JdbcTypeJavaClassMappings.buildJdbcJavaClassMappings();
    private final ConcurrentHashMap<Integer, Class> jdbcTypeCodeToJavaClassMap = JdbcTypeJavaClassMappings.transpose(this.javaClassToJdbcTypeCodeMap);

    private JdbcTypeJavaClassMappings() {
    }

    public int determineJdbcTypeCodeForJavaClass(Class cls) {
        Integer typeCode = this.javaClassToJdbcTypeCodeMap.get(cls);
        if (typeCode != null) {
            return typeCode;
        }
        int specialCode = cls.hashCode();
        log.debug((Object)("JDBC type code mapping not known for class [" + cls.getName() + "]; using custom code [" + specialCode + "]"));
        return specialCode;
    }

    public Class determineJavaClassForJdbcTypeCode(Integer typeCode) {
        Class cls = this.jdbcTypeCodeToJavaClassMap.get(typeCode);
        if (cls != null) {
            return cls;
        }
        log.debugf("Java Class mapping not known for JDBC type code [%s]; using java.lang.Object", (Object)typeCode);
        return Object.class;
    }

    public Class determineJavaClassForJdbcTypeCode(int typeCode) {
        return this.determineJavaClassForJdbcTypeCode((Integer)typeCode);
    }

    private static ConcurrentHashMap<Class, Integer> buildJdbcJavaClassMappings() {
        ConcurrentHashMap<Class, Integer> jdbcJavaClassMappings = new ConcurrentHashMap<Class, Integer>();
        jdbcJavaClassMappings.put(String.class, 12);
        jdbcJavaClassMappings.put(BigDecimal.class, 2);
        jdbcJavaClassMappings.put(Boolean.class, -7);
        jdbcJavaClassMappings.put(Integer.class, 4);
        jdbcJavaClassMappings.put(Long.class, -5);
        jdbcJavaClassMappings.put(Float.class, 7);
        jdbcJavaClassMappings.put(Double.class, 8);
        jdbcJavaClassMappings.put(byte[].class, -4);
        jdbcJavaClassMappings.put(Date.class, 91);
        jdbcJavaClassMappings.put(Time.class, 92);
        jdbcJavaClassMappings.put(Timestamp.class, 93);
        jdbcJavaClassMappings.put(Blob.class, 2004);
        jdbcJavaClassMappings.put(Clob.class, 2005);
        jdbcJavaClassMappings.put(Array.class, 2003);
        jdbcJavaClassMappings.put(Struct.class, 2002);
        jdbcJavaClassMappings.put(Ref.class, 2006);
        jdbcJavaClassMappings.put(Class.class, 2000);
        jdbcJavaClassMappings.put(Character.class, 1);
        jdbcJavaClassMappings.put(char[].class, 12);
        jdbcJavaClassMappings.put(Character[].class, 12);
        jdbcJavaClassMappings.put(Byte[].class, -4);
        jdbcJavaClassMappings.put(Date.class, 93);
        jdbcJavaClassMappings.put(Calendar.class, 93);
        return jdbcJavaClassMappings;
    }

    private static ConcurrentHashMap<Integer, Class> transpose(ConcurrentHashMap<Class, Integer> javaClassToJdbcTypeCodeMap) {
        ConcurrentHashMap<Integer, Class> transposed = new ConcurrentHashMap<Integer, Class>();
        for (Map.Entry<Class, Integer> entry : javaClassToJdbcTypeCodeMap.entrySet()) {
            transposed.put(entry.getValue(), entry.getKey());
        }
        return transposed;
    }
}

