/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeNode;
import javax.persistence.EntityGraph;
import javax.persistence.Subgraph;
import org.hibernate.QueryException;
import org.hibernate.engine.internal.JoinSequence;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.FromClause;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.FromElementFactory;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.sql.JoinType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class EntityGraphQueryHint {
    private final EntityGraph<?> originEntityGraph;

    public EntityGraphQueryHint(EntityGraph<?> originEntityGraph) {
        this.originEntityGraph = originEntityGraph;
    }

    public List<FromElement> toFromElements(FromClause fromClause, HqlSqlWalker walker) {
        HashMap<String, FromElement> explicitFetches = new HashMap<String, FromElement>();
        for (FromElement fromElement : fromClause.getFromElements()) {
            if (fromElement.getRole() == null) continue;
            explicitFetches.put(fromElement.getRole(), fromElement);
        }
        return this.getFromElements(this.originEntityGraph.getAttributeNodes(), fromClause.getFromElement(), fromClause, walker, explicitFetches);
    }

    private List<FromElement> getFromElements(List attributeNodes, FromElement origin, FromClause fromClause, HqlSqlWalker walker, Map<String, FromElement> explicitFetches) {
        ArrayList<FromElement> fromElements = new ArrayList<FromElement>();
        for (Object obj : attributeNodes) {
            AttributeNode attributeNode = (AttributeNode)obj;
            String attributeName = attributeNode.getAttributeName();
            String className = origin.getClassName();
            String role = className + "." + attributeName;
            String classAlias = origin.getClassAlias();
            String originTableAlias = origin.getTableAlias();
            Type propertyType = origin.getPropertyType(attributeName, attributeName);
            try {
                FromElement fromElement = null;
                if (!explicitFetches.containsKey(role)) {
                    if (propertyType.isEntityType()) {
                        EntityType entityType = (EntityType)propertyType;
                        String[] columns = origin.toColumns(originTableAlias, attributeName, false);
                        String tableAlias = walker.getAliasGenerator().createName(entityType.getAssociatedEntityName());
                        FromElementFactory fromElementFactory = new FromElementFactory(fromClause, origin, attributeName, classAlias, columns, false);
                        JoinSequence joinSequence = walker.getSessionFactoryHelper().createJoinSequence(false, entityType, tableAlias, JoinType.LEFT_OUTER_JOIN, columns);
                        fromElement = fromElementFactory.createEntityJoin(entityType.getAssociatedEntityName(), tableAlias, joinSequence, true, walker.isInFrom(), entityType, role, null);
                    } else if (propertyType.isCollectionType()) {
                        String[] columns = origin.toColumns(originTableAlias, attributeName, false);
                        FromElementFactory fromElementFactory = new FromElementFactory(fromClause, origin, attributeName, classAlias, columns, false);
                        QueryableCollection queryableCollection = walker.getSessionFactoryHelper().requireQueryableCollection(role);
                        fromElement = fromElementFactory.createCollection(queryableCollection, role, JoinType.LEFT_OUTER_JOIN, true, false);
                    }
                }
                if (fromElement == null) continue;
                fromElements.add(fromElement);
                for (Subgraph subgraph : attributeNode.getSubgraphs().values()) {
                    fromElements.addAll(this.getFromElements(subgraph.getAttributeNodes(), fromElement, fromClause, walker, explicitFetches));
                }
            }
            catch (Exception e) {
                throw new QueryException("Could not apply the EntityGraph to the Query!", e);
            }
        }
        return fromElements;
    }
}

