/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.exec.spi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.loader.plan2.build.spi.LoadPlanTreePrinter;
import org.hibernate.loader.plan2.exec.internal.AliasResolutionContextImpl;
import org.hibernate.loader.plan2.exec.internal.FetchStats;
import org.hibernate.loader.plan2.exec.internal.Helper;
import org.hibernate.loader.plan2.exec.internal.LoadQueryJoinAndFetchProcessor;
import org.hibernate.loader.plan2.exec.process.internal.EntityReferenceInitializerImpl;
import org.hibernate.loader.plan2.exec.process.internal.EntityReturnReader;
import org.hibernate.loader.plan2.exec.process.internal.ResultSetProcessingContextImpl;
import org.hibernate.loader.plan2.exec.process.internal.ResultSetProcessorHelper;
import org.hibernate.loader.plan2.exec.process.internal.ResultSetProcessorImpl;
import org.hibernate.loader.plan2.exec.process.spi.AbstractRowReader;
import org.hibernate.loader.plan2.exec.process.spi.CollectionReferenceInitializer;
import org.hibernate.loader.plan2.exec.process.spi.EntityReferenceInitializer;
import org.hibernate.loader.plan2.exec.process.spi.ReaderCollector;
import org.hibernate.loader.plan2.exec.process.spi.ResultSetProcessingContext;
import org.hibernate.loader.plan2.exec.process.spi.ResultSetProcessor;
import org.hibernate.loader.plan2.exec.process.spi.RowReader;
import org.hibernate.loader.plan2.exec.query.internal.SelectStatementBuilder;
import org.hibernate.loader.plan2.exec.query.spi.QueryBuildingParameters;
import org.hibernate.loader.plan2.exec.spi.EntityReferenceAliases;
import org.hibernate.loader.plan2.exec.spi.LoadQueryDetails;
import org.hibernate.loader.plan2.spi.EntityQuerySpace;
import org.hibernate.loader.plan2.spi.EntityReturn;
import org.hibernate.loader.plan2.spi.LoadPlan;
import org.hibernate.loader.plan2.spi.QuerySpace;
import org.hibernate.loader.plan2.spi.QuerySpaces;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.ConditionFragment;
import org.hibernate.sql.DisjunctionFragment;
import org.hibernate.sql.InFragment;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class EntityLoadQueryDetails
implements LoadQueryDetails {
    private static final Logger log = CoreLogging.logger(EntityLoadQueryDetails.class);
    private final LoadPlan loadPlan;
    private final String sqlStatement;
    private final ResultSetProcessor resultSetProcessor;

    @Override
    public String getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    public ResultSetProcessor getResultSetProcessor() {
        return this.resultSetProcessor;
    }

    public static EntityLoadQueryDetails makeForBatching(LoadPlan loadPlan, String[] keyColumnNames, QueryBuildingParameters buildingParameters, SessionFactoryImplementor factory) {
        int batchSize = buildingParameters.getBatchSize();
        boolean shouldUseOptionalEntityInformation = batchSize == 1;
        return new EntityLoadQueryDetails(loadPlan, keyColumnNames, shouldUseOptionalEntityInformation, buildingParameters, factory);
    }

    protected EntityLoadQueryDetails(LoadPlan loadPlan, String[] keyColumnNames, boolean shouldUseOptionalEntityInformation, QueryBuildingParameters buildingParameters, SessionFactoryImplementor factory) {
        this.loadPlan = loadPlan;
        AliasResolutionContextImpl aliasResolutionContext = new AliasResolutionContextImpl(factory);
        SelectStatementBuilder select = new SelectStatementBuilder(factory.getDialect());
        EntityReturn rootReturn = Helper.INSTANCE.extractRootReturn(loadPlan, EntityReturn.class);
        ReaderCollectorImpl readerCollector = new ReaderCollectorImpl();
        LoadQueryJoinAndFetchProcessor helper = new LoadQueryJoinAndFetchProcessor(aliasResolutionContext, buildingParameters, factory);
        String[] keyColumnNamesToUse = keyColumnNames != null ? keyColumnNames : ((Queryable)rootReturn.getEntityPersister()).getIdentifierColumnNames();
        this.processQuerySpaces(loadPlan.getQuerySpaces(), select, keyColumnNamesToUse, helper, aliasResolutionContext, buildingParameters, factory);
        FetchStats fetchStats = this.processReturnAndFetches(rootReturn, select, helper, readerCollector, aliasResolutionContext);
        LoadPlanTreePrinter.INSTANCE.logTree(loadPlan, aliasResolutionContext);
        this.sqlStatement = select.toStatementString();
        this.resultSetProcessor = new ResultSetProcessorImpl(loadPlan, readerCollector.buildRowReader(), fetchStats.hasSubselectFetches());
    }

    private FetchStats processReturnAndFetches(EntityReturn rootReturn, SelectStatementBuilder select, LoadQueryJoinAndFetchProcessor helper, ReaderCollectorImpl readerCollector, AliasResolutionContextImpl aliasResolutionContext) {
        EntityReferenceAliases entityReferenceAliases = aliasResolutionContext.resolveEntityReferenceAliases(rootReturn.getQuerySpaceUid());
        OuterJoinLoadable rootLoadable = (OuterJoinLoadable)rootReturn.getEntityPersister();
        select.appendSelectClauseFragment(rootLoadable.selectFragment(entityReferenceAliases.getTableAlias(), entityReferenceAliases.getColumnAliases().getSuffix()));
        FetchStats fetchStats = helper.processFetches(rootReturn, select, readerCollector);
        readerCollector.setRootReturnReader(new EntityReturnReader(rootReturn, entityReferenceAliases));
        readerCollector.add(new EntityReferenceInitializerImpl(rootReturn, entityReferenceAliases, true));
        return fetchStats;
    }

    private void processQuerySpaces(QuerySpaces querySpaces, SelectStatementBuilder select, String[] keyColumnNamesToUse, LoadQueryJoinAndFetchProcessor helper, AliasResolutionContextImpl aliasResolutionContext, QueryBuildingParameters buildingParameters, SessionFactoryImplementor factory) {
        EntityQuerySpace rootQuerySpace = (EntityQuerySpace)Helper.INSTANCE.extractRootQuerySpace(querySpaces, EntityQuerySpace.class);
        EntityReferenceAliases entityReferenceAliases = aliasResolutionContext.generateEntityReferenceAliases(rootQuerySpace.getUid(), rootQuerySpace.getEntityPersister());
        String rootTableAlias = entityReferenceAliases.getTableAlias();
        this.applyTableFragments(select, factory, buildingParameters, rootTableAlias, (OuterJoinLoadable)rootQuerySpace.getEntityPersister());
        EntityLoadQueryDetails.applyKeyRestriction(select, entityReferenceAliases.getTableAlias(), keyColumnNamesToUse, buildingParameters.getBatchSize());
        OuterJoinLoadable rootLoadable = (OuterJoinLoadable)rootQuerySpace.getEntityPersister();
        Queryable rootQueryable = (Queryable)rootQuerySpace.getEntityPersister();
        select.appendRestrictions(rootQueryable.filterFragment(entityReferenceAliases.getTableAlias(), Collections.emptyMap()));
        select.appendRestrictions(rootLoadable.whereJoinFragment(entityReferenceAliases.getTableAlias(), true, true));
        helper.processQuerySpaceJoins((QuerySpace)rootQuerySpace, select);
    }

    private void applyTableFragments(SelectStatementBuilder select, SessionFactoryImplementor factory, QueryBuildingParameters buildingParameters, String rootAlias, OuterJoinLoadable rootLoadable) {
        String fromTableFragment;
        if (buildingParameters.getLockOptions() != null) {
            fromTableFragment = factory.getDialect().appendLockHint(buildingParameters.getLockOptions(), rootLoadable.fromTableFragment(rootAlias));
            select.setLockOptions(buildingParameters.getLockOptions());
        } else if (buildingParameters.getLockMode() != null) {
            fromTableFragment = factory.getDialect().appendLockHint(buildingParameters.getLockMode(), rootLoadable.fromTableFragment(rootAlias));
            select.setLockMode(buildingParameters.getLockMode());
        } else {
            fromTableFragment = rootLoadable.fromTableFragment(rootAlias);
        }
        select.appendFromClauseFragment(fromTableFragment + rootLoadable.fromJoinFragment(rootAlias, true, true));
    }

    private static void applyKeyRestriction(SelectStatementBuilder select, String alias, String[] keyColumnNames, int batchSize) {
        if (keyColumnNames.length == 1) {
            InFragment in = new InFragment().setColumn(alias, keyColumnNames[0]);
            for (int i = 0; i < batchSize; ++i) {
                in.addValue("?");
            }
            select.appendRestrictions(in.toFragmentString());
        } else {
            ConditionFragment keyRestrictionBuilder = new ConditionFragment().setTableAlias(alias).setCondition(keyColumnNames, "?");
            String keyRestrictionFragment = keyRestrictionBuilder.toFragmentString();
            StringBuilder restrictions = new StringBuilder();
            if (batchSize == 1) {
                restrictions.append(keyRestrictionFragment);
            } else {
                restrictions.append('(');
                DisjunctionFragment df = new DisjunctionFragment();
                for (int i = 0; i < batchSize; ++i) {
                    df.addCondition(keyRestrictionFragment);
                }
                restrictions.append(df.toFragmentString());
                restrictions.append(')');
            }
            select.appendRestrictions(restrictions.toString());
        }
    }

    public static class EntityLoaderRowReader
    extends AbstractRowReader {
        private final EntityReturnReader rootReturnReader;
        private final List<EntityReferenceInitializer> entityReferenceInitializers;
        private final List<CollectionReferenceInitializer> arrayReferenceInitializers;
        private final List<CollectionReferenceInitializer> collectionReferenceInitializers;

        public EntityLoaderRowReader(EntityReturnReader rootReturnReader, List<EntityReferenceInitializer> entityReferenceInitializers, List<CollectionReferenceInitializer> arrayReferenceInitializers, List<CollectionReferenceInitializer> collectionReferenceInitializers) {
            this.rootReturnReader = rootReturnReader;
            this.entityReferenceInitializers = entityReferenceInitializers != null ? entityReferenceInitializers : Collections.emptyList();
            this.arrayReferenceInitializers = arrayReferenceInitializers != null ? arrayReferenceInitializers : Collections.emptyList();
            this.collectionReferenceInitializers = collectionReferenceInitializers != null ? collectionReferenceInitializers : Collections.emptyList();
        }

        @Override
        public Object readRow(ResultSet resultSet, ResultSetProcessingContextImpl context) throws SQLException {
            ResultSetProcessingContext.EntityReferenceProcessingState processingState = this.rootReturnReader.getIdentifierResolutionContext(context);
            if (context.shouldUseOptionalEntityInformation() && context.getQueryParameters().getOptionalId() != null) {
                ComponentType identifierType;
                EntityKey entityKey = ResultSetProcessorHelper.getOptionalObjectKey(context.getQueryParameters(), context.getSession());
                processingState.registerIdentifierHydratedForm(entityKey.getIdentifier());
                processingState.registerEntityKey(entityKey);
                EntityPersister entityPersister = processingState.getEntityReference().getEntityPersister();
                if (entityPersister.getIdentifierType().isComponentType() && !(identifierType = (ComponentType)entityPersister.getIdentifierType()).isEmbedded()) {
                    this.addKeyManyToOnesToSession(context, identifierType, entityKey.getIdentifier());
                }
            }
            return super.readRow(resultSet, context);
        }

        private void addKeyManyToOnesToSession(ResultSetProcessingContextImpl context, ComponentType componentType, Object component) {
            for (int i = 0; i < componentType.getSubtypes().length; ++i) {
                Type subType = componentType.getSubtypes()[i];
                Object subValue = componentType.getPropertyValue(component, i, context.getSession());
                if (subType.isEntityType()) {
                    ((Session)((Object)context.getSession())).buildLockRequest(LockOptions.NONE).lock(subValue);
                    continue;
                }
                if (!subType.isComponentType()) continue;
                this.addKeyManyToOnesToSession(context, (ComponentType)subType, subValue);
            }
        }

        @Override
        protected List<EntityReferenceInitializer> getEntityReferenceInitializers() {
            return this.entityReferenceInitializers;
        }

        @Override
        protected List<CollectionReferenceInitializer> getCollectionReferenceInitializers() {
            return this.collectionReferenceInitializers;
        }

        @Override
        protected List<CollectionReferenceInitializer> getArrayReferenceInitializers() {
            return this.arrayReferenceInitializers;
        }

        @Override
        protected Object readLogicalRow(ResultSet resultSet, ResultSetProcessingContextImpl context) throws SQLException {
            return this.rootReturnReader.read(resultSet, context);
        }
    }

    private static class ReaderCollectorImpl
    implements ReaderCollector {
        private EntityReturnReader rootReturnReader;
        private final List<EntityReferenceInitializer> entityReferenceInitializers = new ArrayList<EntityReferenceInitializer>();
        private List<CollectionReferenceInitializer> arrayReferenceInitializers;
        private List<CollectionReferenceInitializer> collectionReferenceInitializers;

        private ReaderCollectorImpl() {
        }

        @Override
        public void add(CollectionReferenceInitializer collectionReferenceInitializer) {
            if (collectionReferenceInitializer.getCollectionReference().getCollectionPersister().isArray()) {
                if (this.arrayReferenceInitializers == null) {
                    this.arrayReferenceInitializers = new ArrayList<CollectionReferenceInitializer>();
                }
                this.arrayReferenceInitializers.add(collectionReferenceInitializer);
            } else {
                if (this.collectionReferenceInitializers == null) {
                    this.collectionReferenceInitializers = new ArrayList<CollectionReferenceInitializer>();
                }
                this.collectionReferenceInitializers.add(collectionReferenceInitializer);
            }
        }

        @Override
        public void add(EntityReferenceInitializer entityReferenceInitializer) {
            if (EntityReturnReader.class.isInstance(entityReferenceInitializer)) {
                this.setRootReturnReader((EntityReturnReader)((Object)entityReferenceInitializer));
            }
            this.entityReferenceInitializers.add(entityReferenceInitializer);
        }

        public RowReader buildRowReader() {
            return new EntityLoaderRowReader(this.rootReturnReader, this.entityReferenceInitializers, this.arrayReferenceInitializers, this.collectionReferenceInitializers);
        }

        public void setRootReturnReader(EntityReturnReader entityReturnReader) {
            if (this.rootReturnReader != null) {
                throw new IllegalStateException("Root return reader already set");
            }
            this.rootReturnReader = entityReturnReader;
        }
    }
}

