/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.build.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan2.build.internal.spaces.QuerySpacesImpl;
import org.hibernate.loader.plan2.spi.AbstractPlanNode;
import org.hibernate.loader.plan2.spi.Join;
import org.hibernate.loader.plan2.spi.QuerySpace;

public abstract class AbstractQuerySpace
extends AbstractPlanNode
implements QuerySpace {
    private final String uid;
    private final QuerySpace.Disposition disposition;
    private final QuerySpacesImpl querySpaces;
    private final boolean canJoinsBeRequired;
    private List<Join> joins;

    public AbstractQuerySpace(String uid, QuerySpace.Disposition disposition, QuerySpacesImpl querySpaces, boolean canJoinsBeRequired, SessionFactoryImplementor sessionFactory) {
        super(sessionFactory);
        this.uid = uid;
        this.disposition = disposition;
        this.querySpaces = querySpaces;
        this.canJoinsBeRequired = canJoinsBeRequired;
    }

    @Override
    protected SessionFactoryImplementor sessionFactory() {
        return super.sessionFactory();
    }

    public boolean canJoinsBeRequired() {
        return this.canJoinsBeRequired;
    }

    @Override
    public QuerySpacesImpl getQuerySpaces() {
        return this.querySpaces;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public QuerySpace.Disposition getDisposition() {
        return this.disposition;
    }

    @Override
    public Iterable<Join> getJoins() {
        return this.joins == null ? Collections.emptyList() : this.joins;
    }

    protected List<Join> internalGetJoins() {
        if (this.joins == null) {
            this.joins = new ArrayList<Join>();
        }
        return this.joins;
    }
}

