/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.build.spi;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.plan2.build.internal.returns.CollectionReturnImpl;
import org.hibernate.loader.plan2.build.internal.returns.EntityReturnImpl;
import org.hibernate.loader.plan2.build.internal.spaces.QuerySpacesImpl;
import org.hibernate.loader.plan2.build.spi.ExpandingEntityIdentifierDescription;
import org.hibernate.loader.plan2.build.spi.ExpandingFetchSource;
import org.hibernate.loader.plan2.build.spi.ExpandingQuerySpaces;
import org.hibernate.loader.plan2.build.spi.LoadPlanBuildingAssociationVisitationStrategy;
import org.hibernate.loader.plan2.build.spi.LoadPlanBuildingContext;
import org.hibernate.loader.plan2.spi.CollectionFetch;
import org.hibernate.loader.plan2.spi.CollectionFetchableElement;
import org.hibernate.loader.plan2.spi.CollectionFetchableIndex;
import org.hibernate.loader.plan2.spi.CollectionReference;
import org.hibernate.loader.plan2.spi.CompositeFetch;
import org.hibernate.loader.plan2.spi.EntityFetch;
import org.hibernate.loader.plan2.spi.EntityIdentifierDescription;
import org.hibernate.loader.plan2.spi.EntityReference;
import org.hibernate.loader.plan2.spi.FetchSource;
import org.hibernate.loader.plan2.spi.Return;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.walking.spi.AnyMappingDefinition;
import org.hibernate.persister.walking.spi.AssociationAttributeDefinition;
import org.hibernate.persister.walking.spi.AssociationKey;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.persister.walking.spi.CollectionDefinition;
import org.hibernate.persister.walking.spi.CollectionElementDefinition;
import org.hibernate.persister.walking.spi.CollectionIndexDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;
import org.hibernate.persister.walking.spi.EntityDefinition;
import org.hibernate.persister.walking.spi.EntityIdentifierDefinition;
import org.hibernate.persister.walking.spi.WalkingException;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;
import org.jboss.logging.MDC;

public abstract class AbstractLoadPlanBuildingAssociationVisitationStrategy
implements LoadPlanBuildingAssociationVisitationStrategy,
LoadPlanBuildingContext {
    private static final Logger log = Logger.getLogger(AbstractLoadPlanBuildingAssociationVisitationStrategy.class);
    private static final String MDC_KEY = "hibernateLoadPlanWalkPath";
    private final SessionFactoryImplementor sessionFactory;
    private final QuerySpacesImpl querySpaces;
    private final ArrayDeque<ExpandingFetchSource> fetchSourceStack = new ArrayDeque();
    private ArrayDeque<CollectionReference> collectionReferenceStack = new ArrayDeque();
    protected PropertyPath currentPropertyPath = new PropertyPath("");
    private Map<AssociationKey, FetchSource> fetchedAssociationKeySourceMap = new HashMap<AssociationKey, FetchSource>();

    protected AbstractLoadPlanBuildingAssociationVisitationStrategy(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.querySpaces = new QuerySpacesImpl(sessionFactory);
    }

    public SessionFactoryImplementor sessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public ExpandingQuerySpaces getQuerySpaces() {
        return this.querySpaces;
    }

    private void pushToStack(ExpandingFetchSource fetchSource) {
        log.trace((Object)("Pushing fetch source to stack : " + fetchSource));
        this.mdcStack().push(fetchSource.getPropertyPath());
        this.fetchSourceStack.addFirst(fetchSource);
    }

    private MDCStack mdcStack() {
        return (MDCStack)MDC.get((String)MDC_KEY);
    }

    private ExpandingFetchSource popFromStack() {
        ExpandingFetchSource last = this.fetchSourceStack.removeFirst();
        log.trace((Object)("Popped fetch owner from stack : " + last));
        this.mdcStack().pop();
        if (FetchStackAware.class.isInstance(last)) {
            ((FetchStackAware)((Object)last)).poppedFromStack();
        }
        return last;
    }

    private ExpandingFetchSource currentSource() {
        return this.fetchSourceStack.peekFirst();
    }

    @Override
    public void start() {
        if (!this.fetchSourceStack.isEmpty()) {
            throw new WalkingException("Fetch owner stack was not empty on start; be sure to not use LoadPlanBuilderStrategy instances concurrently");
        }
        MDC.put((String)MDC_KEY, (Object)new MDCStack());
    }

    @Override
    public void finish() {
        MDC.remove((String)MDC_KEY);
        this.fetchSourceStack.clear();
    }

    protected abstract void addRootReturn(Return var1);

    protected boolean supportsRootEntityReturns() {
        return true;
    }

    @Override
    public void startingEntity(EntityDefinition entityDefinition) {
        log.tracef("%s Starting entity : %s", (Object)StringHelper.repeat(">>", this.fetchSourceStack.size()), (Object)entityDefinition.getEntityPersister().getEntityName());
        boolean isRoot = this.fetchSourceStack.isEmpty();
        if (!isRoot) {
            return;
        }
        if (!this.supportsRootEntityReturns()) {
            throw new HibernateException("This strategy does not support root entity returns");
        }
        EntityReturnImpl entityReturn = new EntityReturnImpl(entityDefinition, this);
        this.addRootReturn(entityReturn);
        this.pushToStack(entityReturn);
        Joinable entityPersister = (Joinable)((Object)entityDefinition.getEntityPersister());
        this.associationKeyRegistered(new AssociationKey(entityPersister.getTableName(), entityPersister.getKeyColumnNames()));
    }

    @Override
    public void finishingEntity(EntityDefinition entityDefinition) {
        ExpandingFetchSource fetchSource = this.popFromStack();
        if (!EntityReference.class.isInstance(fetchSource)) {
            throw new WalkingException(String.format("Mismatched FetchSource from stack on pop.  Expecting EntityReference(%s), but found %s", entityDefinition.getEntityPersister().getEntityName(), fetchSource));
        }
        EntityReference entityReference = (EntityReference)((Object)fetchSource);
        if (!entityReference.getEntityPersister().equals(entityDefinition.getEntityPersister())) {
            throw new WalkingException("Mismatched FetchSource from stack on pop");
        }
        log.tracef("%s Finished entity : %s", (Object)StringHelper.repeat("<<", this.fetchSourceStack.size()), (Object)entityDefinition.getEntityPersister().getEntityName());
    }

    @Override
    public void startingEntityIdentifier(EntityIdentifierDefinition entityIdentifierDefinition) {
        log.tracef("%s Starting entity identifier : %s", (Object)StringHelper.repeat(">>", this.fetchSourceStack.size()), (Object)entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName());
        EntityReference entityReference = (EntityReference)((Object)this.currentSource());
        if (!entityReference.getEntityPersister().equals(entityIdentifierDefinition.getEntityDefinition().getEntityPersister())) {
            throw new WalkingException(String.format("Encountered unexpected fetch owner [%s] in stack while processing entity identifier for [%s]", entityReference.getEntityPersister().getEntityName(), entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName()));
        }
        if (ExpandingEntityIdentifierDescription.class.isInstance(entityReference.getIdentifierDescription())) {
            this.pushToStack((ExpandingEntityIdentifierDescription)entityReference.getIdentifierDescription());
        }
    }

    @Override
    public void finishingEntityIdentifier(EntityIdentifierDefinition entityIdentifierDefinition) {
        ExpandingFetchSource current = this.currentSource();
        if (!EntityIdentifierDescription.class.isInstance(current)) {
            return;
        }
        ExpandingFetchSource popped = this.popFromStack();
        if (!ExpandingEntityIdentifierDescription.class.isInstance(popped)) {
            throw new WalkingException("Unexpected state in FetchSource stack");
        }
        ExpandingEntityIdentifierDescription identifierDescription = (ExpandingEntityIdentifierDescription)popped;
        ExpandingFetchSource entitySource = this.currentSource();
        if (!EntityReference.class.isInstance(entitySource)) {
            throw new WalkingException("Unexpected state in FetchSource stack");
        }
        EntityReference entityReference = (EntityReference)((Object)entitySource);
        if (entityReference.getIdentifierDescription() != identifierDescription) {
            throw new WalkingException(String.format("Encountered unexpected fetch owner [%s] in stack while processing entity identifier for [%s]", entityReference.getEntityPersister().getEntityName(), entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName()));
        }
        log.tracef("%s Finished entity identifier : %s", (Object)StringHelper.repeat("<<", this.fetchSourceStack.size()), (Object)entityIdentifierDefinition.getEntityDefinition().getEntityPersister().getEntityName());
    }

    private void pushToCollectionStack(CollectionReference collectionReference) {
        log.trace((Object)("Pushing collection reference to stack : " + collectionReference));
        this.mdcStack().push(collectionReference.getPropertyPath());
        this.collectionReferenceStack.addFirst(collectionReference);
    }

    private CollectionReference popFromCollectionStack() {
        CollectionReference last = this.collectionReferenceStack.removeFirst();
        log.trace((Object)("Popped collection reference from stack : " + last));
        this.mdcStack().pop();
        if (FetchStackAware.class.isInstance(last)) {
            ((FetchStackAware)((Object)last)).poppedFromStack();
        }
        return last;
    }

    @Override
    public void startingCollection(CollectionDefinition collectionDefinition) {
        log.tracef("%s Starting collection : %s", (Object)StringHelper.repeat(">>", this.fetchSourceStack.size()), (Object)collectionDefinition.getCollectionPersister().getRole());
        boolean isRoot = this.fetchSourceStack.isEmpty();
        if (!isRoot) {
            return;
        }
        if (!this.supportsRootCollectionReturns()) {
            throw new HibernateException("This strategy does not support root collection returns");
        }
        CollectionReturnImpl collectionReturn = new CollectionReturnImpl(collectionDefinition, this);
        this.pushToCollectionStack(collectionReturn);
        this.addRootReturn(collectionReturn);
        if (collectionReturn.getElementGraph() != null && EntityReference.class.isInstance(collectionReturn.getElementGraph())) {
            EntityReference entityReference = (EntityReference)((Object)collectionReturn.getElementGraph());
            Joinable entityPersister = (Joinable)((Object)entityReference.getEntityPersister());
            this.associationKeyRegistered(new AssociationKey(entityPersister.getTableName(), entityPersister.getKeyColumnNames()));
        }
    }

    protected boolean supportsRootCollectionReturns() {
        return true;
    }

    @Override
    public void finishingCollection(CollectionDefinition collectionDefinition) {
        CollectionReference collectionReference = this.popFromCollectionStack();
        if (!collectionReference.getCollectionPersister().equals(collectionDefinition.getCollectionPersister())) {
            throw new WalkingException("Mismatched FetchSource from stack on pop");
        }
        log.tracef("%s Finished collection : %s", (Object)StringHelper.repeat("<<", this.fetchSourceStack.size()), (Object)collectionDefinition.getCollectionPersister().getRole());
    }

    @Override
    public void startingCollectionIndex(CollectionIndexDefinition indexDefinition) {
        Type indexType = indexDefinition.getType();
        if (indexType.isAnyType()) {
            throw new WalkingException("CollectionIndexDefinition reported any-type mapping as map index");
        }
        log.tracef("%s Starting collection index graph : %s", (Object)StringHelper.repeat(">>", this.fetchSourceStack.size()), (Object)indexDefinition.getCollectionDefinition().getCollectionPersister().getRole());
        CollectionReference collectionReference = this.collectionReferenceStack.peekFirst();
        CollectionFetchableIndex indexGraph = collectionReference.getIndexGraph();
        if (indexType.isEntityType() || indexType.isComponentType()) {
            if (indexGraph == null) {
                throw new WalkingException("CollectionReference did not return an expected index graph : " + indexDefinition.getCollectionDefinition().getCollectionPersister().getRole());
            }
            this.pushToStack((ExpandingFetchSource)((Object)indexGraph));
        } else if (indexGraph != null) {
            throw new WalkingException("CollectionReference returned an unexpected index graph : " + indexDefinition.getCollectionDefinition().getCollectionPersister().getRole());
        }
    }

    @Override
    public void finishingCollectionIndex(CollectionIndexDefinition indexDefinition) {
        Type indexType = indexDefinition.getType();
        if (indexType.isComponentType()) {
            this.popFromStack();
        }
        log.tracef("%s Finished collection index graph : %s", (Object)StringHelper.repeat("<<", this.fetchSourceStack.size()), (Object)indexDefinition.getCollectionDefinition().getCollectionPersister().getRole());
    }

    @Override
    public void startingCollectionElements(CollectionElementDefinition elementDefinition) {
        Type elementType = elementDefinition.getType();
        if (elementType.isAnyType()) {
            return;
        }
        log.tracef("%s Starting collection element graph : %s", (Object)StringHelper.repeat(">>", this.fetchSourceStack.size()), (Object)elementDefinition.getCollectionDefinition().getCollectionPersister().getRole());
        CollectionReference collectionReference = this.collectionReferenceStack.peekFirst();
        CollectionFetchableElement elementGraph = collectionReference.getElementGraph();
        if (elementType.isAssociationType() || elementType.isComponentType()) {
            if (elementGraph == null) {
                throw new IllegalStateException("CollectionReference did not return an expected element graph : " + elementDefinition.getCollectionDefinition().getCollectionPersister().getRole());
            }
            this.pushToStack((ExpandingFetchSource)((Object)elementGraph));
        } else if (elementGraph != null) {
            throw new IllegalStateException("CollectionReference returned an unexpected element graph : " + elementDefinition.getCollectionDefinition().getCollectionPersister().getRole());
        }
    }

    @Override
    public void finishingCollectionElements(CollectionElementDefinition elementDefinition) {
        ExpandingFetchSource popped;
        Type elementType = elementDefinition.getType();
        if (elementType.isComponentType() && !CollectionFetchableElement.class.isInstance(popped = this.popFromStack())) {
            throw new WalkingException("Mismatched FetchSource from stack on pop");
        }
        log.tracef("%s Finished collection element graph : %s", (Object)StringHelper.repeat("<<", this.fetchSourceStack.size()), (Object)elementDefinition.getCollectionDefinition().getCollectionPersister().getRole());
    }

    @Override
    public void startingComposite(CompositionDefinition compositionDefinition) {
        log.tracef("%s Starting composite : %s", (Object)StringHelper.repeat(">>", this.fetchSourceStack.size()), (Object)compositionDefinition.getName());
        if (this.fetchSourceStack.isEmpty()) {
            throw new HibernateException("A component cannot be the root of a walk nor a graph");
        }
        CompositeFetch compositeFetch = this.currentSource().buildCompositeFetch(compositionDefinition, this);
        this.pushToStack((ExpandingFetchSource)((Object)compositeFetch));
    }

    @Override
    public void finishingComposite(CompositionDefinition compositionDefinition) {
        ExpandingFetchSource popped = this.popFromStack();
        if (!CompositeFetch.class.isInstance(popped)) {
            throw new WalkingException("Mismatched FetchSource from stack on pop");
        }
        log.tracef("%s Finishing composite : %s", (Object)StringHelper.repeat("<<", this.fetchSourceStack.size()), (Object)compositionDefinition.getName());
    }

    @Override
    public boolean startingAttribute(AttributeDefinition attributeDefinition) {
        log.tracef("%s Starting attribute %s", (Object)StringHelper.repeat(">>", this.fetchSourceStack.size()), (Object)attributeDefinition);
        Type attributeType = attributeDefinition.getType();
        boolean isComponentType = attributeType.isComponentType();
        boolean isAssociationType = attributeType.isAssociationType();
        boolean isBasicType = !isComponentType && !isAssociationType;
        this.currentPropertyPath = this.currentPropertyPath.append(attributeDefinition.getName());
        if (isBasicType) {
            return true;
        }
        if (isAssociationType) {
            return this.handleAssociationAttribute((AssociationAttributeDefinition)attributeDefinition);
        }
        return this.handleCompositeAttribute((CompositionDefinition)attributeDefinition);
    }

    @Override
    public void finishingAttribute(AttributeDefinition attributeDefinition) {
        log.tracef("%s Finishing up attribute : %s", (Object)StringHelper.repeat("<<", this.fetchSourceStack.size()), (Object)attributeDefinition);
        this.currentPropertyPath = this.currentPropertyPath.getParent();
    }

    @Override
    public boolean isDuplicateAssociationKey(AssociationKey associationKey) {
        return this.fetchedAssociationKeySourceMap.containsKey(associationKey);
    }

    @Override
    public void associationKeyRegistered(AssociationKey associationKey) {
        log.tracef("%s Registering AssociationKey : %s -> %s", (Object)StringHelper.repeat("..", this.fetchSourceStack.size()), (Object)associationKey, (Object)this.currentSource());
        this.fetchedAssociationKeySourceMap.put(associationKey, this.currentSource());
    }

    @Override
    public FetchSource registeredFetchSource(AssociationKey associationKey) {
        return this.fetchedAssociationKeySourceMap.get(associationKey);
    }

    @Override
    public void foundCircularAssociation(AssociationAttributeDefinition attributeDefinition) {
        Joinable currentEntityPersister;
        AssociationKey currentEntityReferenceAssociationKey;
        FetchStrategy fetchStrategy = this.determineFetchStrategy(attributeDefinition);
        if (fetchStrategy.getStyle() != FetchStyle.JOIN) {
            return;
        }
        AssociationKey associationKey = attributeDefinition.getAssociationKey();
        if (attributeDefinition.getAssociationNature() == AssociationAttributeDefinition.AssociationNature.ENTITY && !associationKey.equals(currentEntityReferenceAssociationKey = new AssociationKey((currentEntityPersister = (Joinable)((Object)this.currentSource().resolveEntityReference().getEntityPersister())).getTableName(), currentEntityPersister.getKeyColumnNames()))) {
            this.currentSource().buildBidirectionalEntityReference(attributeDefinition, fetchStrategy, this.registeredFetchSource(associationKey).resolveEntityReference(), this);
        }
    }

    @Override
    public void foundAny(AssociationAttributeDefinition attributeDefinition, AnyMappingDefinition anyDefinition) {
        FetchStrategy fetchStrategy = this.determineFetchStrategy(attributeDefinition);
    }

    protected boolean handleCompositeAttribute(CompositionDefinition attributeDefinition) {
        return true;
    }

    protected boolean handleAssociationAttribute(AssociationAttributeDefinition attributeDefinition) {
        FetchStrategy fetchStrategy = this.determineFetchStrategy(attributeDefinition);
        if (fetchStrategy.getStyle() != FetchStyle.JOIN) {
            return false;
        }
        ExpandingFetchSource currentSource = this.currentSource();
        currentSource.validateFetchPlan(fetchStrategy, attributeDefinition);
        AssociationAttributeDefinition.AssociationNature nature = attributeDefinition.getAssociationNature();
        if (nature == AssociationAttributeDefinition.AssociationNature.ANY) {
            return false;
        }
        if (nature == AssociationAttributeDefinition.AssociationNature.ENTITY) {
            EntityFetch fetch = currentSource.buildEntityFetch(attributeDefinition, fetchStrategy, this);
            this.pushToStack((ExpandingFetchSource)((Object)fetch));
        } else {
            CollectionFetch fetch = currentSource.buildCollectionFetch(attributeDefinition, fetchStrategy, this);
            this.pushToCollectionStack(fetch);
        }
        return true;
    }

    protected abstract FetchStrategy determineFetchStrategy(AssociationAttributeDefinition var1);

    protected int currentDepth() {
        return this.fetchSourceStack.size();
    }

    protected boolean isTooManyCollections() {
        return false;
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory();
    }

    public static class MDCStack {
        private ArrayDeque<PropertyPath> pathStack = new ArrayDeque();

        public void push(PropertyPath path) {
            this.pathStack.addFirst(path);
        }

        public void pop() {
            this.pathStack.removeFirst();
        }

        public String toString() {
            PropertyPath path = this.pathStack.peekFirst();
            return path == null ? "<no-path>" : path.getFullPath();
        }
    }

    public static interface FetchStackAware {
        public void poppedFromStack();
    }
}

