/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan2.build.internal.spaces;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.plan2.build.internal.spaces.CollectionQuerySpaceImpl;
import org.hibernate.loader.plan2.build.internal.spaces.CompositePropertyMapping;
import org.hibernate.loader.plan2.build.internal.spaces.CompositeQuerySpaceImpl;
import org.hibernate.loader.plan2.build.internal.spaces.Helper;
import org.hibernate.loader.plan2.build.internal.spaces.JoinImpl;
import org.hibernate.loader.plan2.build.internal.spaces.QuerySpacesImpl;
import org.hibernate.loader.plan2.build.spi.AbstractQuerySpace;
import org.hibernate.loader.plan2.build.spi.ExpandingEntityQuerySpace;
import org.hibernate.loader.plan2.spi.Join;
import org.hibernate.loader.plan2.spi.QuerySpace;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.walking.spi.AttributeDefinition;
import org.hibernate.persister.walking.spi.CompositionDefinition;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;

public class EntityQuerySpaceImpl
extends AbstractQuerySpace
implements ExpandingEntityQuerySpace {
    private final EntityPersister persister;

    public EntityQuerySpaceImpl(EntityPersister persister, String uid, QuerySpacesImpl querySpaces, boolean canJoinsBeRequired, SessionFactoryImplementor sessionFactory) {
        super(uid, QuerySpace.Disposition.ENTITY, querySpaces, canJoinsBeRequired, sessionFactory);
        this.persister = persister;
    }

    @Override
    protected SessionFactoryImplementor sessionFactory() {
        return super.sessionFactory();
    }

    @Override
    public PropertyMapping getPropertyMapping() {
        return (PropertyMapping)((Object)this.persister);
    }

    @Override
    public EntityPersister getEntityPersister() {
        return this.persister;
    }

    @Override
    public JoinImpl addCompositeJoin(CompositionDefinition compositionDefinition, String querySpaceUid) {
        boolean required = this.canJoinsBeRequired() && !compositionDefinition.isNullable();
        CompositeQuerySpaceImpl rhs = new CompositeQuerySpaceImpl(new CompositePropertyMapping(compositionDefinition.getType(), (PropertyMapping)((Object)this.getEntityPersister()), compositionDefinition.getName()), querySpaceUid, this.getQuerySpaces(), required, this.sessionFactory());
        this.getQuerySpaces().registerQuerySpace(rhs);
        JoinImpl join = new JoinImpl(this, compositionDefinition.getName(), rhs, null, null, required);
        this.internalGetJoins().add(join);
        return join;
    }

    @Override
    public JoinImpl addEntityJoin(AttributeDefinition attribute, EntityPersister persister, String querySpaceUid, boolean optional) {
        boolean isMultiTable = ((Queryable)Queryable.class.cast(persister)).isMultiTable();
        boolean required = this.canJoinsBeRequired() && !isMultiTable && !optional;
        EntityQuerySpaceImpl rhs = new EntityQuerySpaceImpl(persister, querySpaceUid, this.getQuerySpaces(), required, this.sessionFactory());
        this.getQuerySpaces().registerQuerySpace(rhs);
        JoinImpl join = new JoinImpl(this, attribute.getName(), rhs, Helper.INSTANCE.determineRhsColumnNames((EntityType)attribute.getType(), this.sessionFactory()), (AssociationType)attribute.getType(), required);
        this.internalGetJoins().add(join);
        return join;
    }

    @Override
    public JoinImpl addCollectionJoin(AttributeDefinition attributeDefinition, CollectionPersister collectionPersister, String querySpaceUid) {
        boolean required = this.canJoinsBeRequired() && !attributeDefinition.isNullable();
        CollectionQuerySpaceImpl rhs = new CollectionQuerySpaceImpl(collectionPersister, querySpaceUid, this.getQuerySpaces(), required, this.sessionFactory());
        this.getQuerySpaces().registerQuerySpace(rhs);
        JoinImpl join = new JoinImpl(this, attributeDefinition.getName(), rhs, ((CollectionType)attributeDefinition.getType()).getAssociatedJoinable(this.sessionFactory()).getKeyColumnNames(), (AssociationType)attributeDefinition.getType(), required);
        this.internalGetJoins().add(join);
        return join;
    }

    @Override
    public Join makeCompositeIdentifierJoin() {
        String compositeQuerySpaceUid = this.getUid() + "-id";
        CompositeQuerySpaceImpl rhs = new CompositeQuerySpaceImpl(this, new CompositePropertyMapping((CompositeType)this.getEntityPersister().getIdentifierType(), (PropertyMapping)((Object)this.getEntityPersister()), this.getEntityPersister().getIdentifierPropertyName()), compositeQuerySpaceUid, this.canJoinsBeRequired());
        this.getQuerySpaces().registerQuerySpace(rhs);
        JoinImpl join = new JoinImpl(this, "id", rhs, null, null, this.canJoinsBeRequired());
        this.internalGetJoins().add(join);
        return join;
    }
}

